/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.weightingfunctions;

import marytts.unitselection.weightingfunctions.WeightFunc;

public class WeightingFunction {

    public static class linear
    implements WeightFunc {
        @Override
        public double cost(double a, double b) {
            return a > b ? a - b : b - a;
        }

        @Override
        public void setParam(String val) {
        }

        @Override
        public String whoAmI() {
            return "linear";
        }
    }

    public static class step
    implements WeightFunc {
        private double stepVal;

        @Override
        public double cost(double a, double b) {
            double res = a > b ? a - b : b - a;
            double dev = res / ((a + b) / 2.0);
            if (dev < this.stepVal) {
                return res;
            }
            return 0.0;
        }

        @Override
        public void setParam(String val) {
            this.stepVal = Double.parseDouble(val.substring(0, val.indexOf("%"))) / 100.0;
        }

        @Override
        public String whoAmI() {
            return "step " + Double.toString(100.0 * this.stepVal) + "%";
        }
    }
}

