/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.math;

import Jama.Matrix;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Vector;
import marytts.util.math.MathUtils;

public class Regression {
    private double[] coeffs;
    private double[] residuals;
    private double[] predictedValues = null;
    private double correlation;
    private double rmse;
    private Matrix b = null;
    private boolean b0Term;

    public double[] getCoeffs() {
        return this.coeffs;
    }

    public void setCoeffs(double[] coeffsVal) {
        this.coeffs = new double[coeffsVal.length];
        int i = 0;
        while (i < this.coeffs.length) {
            this.coeffs[i] = coeffsVal[i];
            ++i;
        }
        this.b = new Matrix(this.coeffs, this.coeffs.length);
    }

    public double[] getResiduals() {
        return this.residuals;
    }

    public double[] getPredictedValues() {
        return this.predictedValues;
    }

    public double getCorrelation() {
        return this.correlation;
    }

    public double getRMSE() {
        return this.rmse;
    }

    public double[] multipleLinearRegression(double[] data, int rows, int cols, boolean interceptTerm) {
        Matrix dataX;
        if (data == null) {
            throw new NullPointerException("Null data");
        }
        if (rows < 0 || cols < 0) {
            throw new IllegalArgumentException("Number of rows and cols must be greater than 0");
        }
        this.b0Term = interceptTerm;
        if (interceptTerm) {
            dataX = new Matrix(rows, cols);
            this.coeffs = new double[cols];
        } else {
            dataX = new Matrix(rows, cols - 1);
            this.coeffs = new double[cols - 1];
        }
        double[] datay = new double[rows];
        int n = 0;
        int i = 0;
        while (i < rows) {
            int j;
            if (interceptTerm) {
                dataX.set(i, 0, 1.0);
                datay[i] = data[n++];
                j = 1;
                while (j < cols) {
                    dataX.set(i, j, data[n++]);
                    ++j;
                }
            } else {
                datay[i] = data[n++];
                j = 0;
                while (j < cols - 1) {
                    dataX.set(i, j, data[n++]);
                    ++j;
                }
            }
            ++i;
        }
        this.multipleLinearRegression(datay, dataX);
        return this.coeffs;
    }

    public double[] multipleLinearRegression(double[] datay, double[][] datax, boolean interceptTerm) {
        Matrix dataX;
        if (datay == null || datax == null) {
            throw new NullPointerException("Null data");
        }
        this.b0Term = interceptTerm;
        int rows = datay.length;
        int cols = datax[0].length;
        if (interceptTerm) {
            dataX = new Matrix(rows, cols + 1);
            this.coeffs = new double[cols + 1];
        } else {
            dataX = new Matrix(datax);
            this.coeffs = new double[cols];
        }
        if (interceptTerm) {
            int i = 0;
            while (i < rows) {
                dataX.set(i, 0, 1.0);
                int j = 1;
                while (j < cols + 1) {
                    dataX.set(i, j, datax[i][j - 1]);
                    ++j;
                }
                ++i;
            }
        }
        this.multipleLinearRegression(datay, dataX);
        return this.coeffs;
    }

    public double[] multipleLinearRegression(Vector<Double> vectory, Vector<Double> vectorx, int rows, int cols, boolean interceptTerm) {
        Matrix dataX;
        if (vectory == null || vectorx == null) {
            throw new NullPointerException("Null data");
        }
        this.b0Term = interceptTerm;
        if (interceptTerm) {
            dataX = new Matrix(rows, cols + 1);
            this.coeffs = new double[cols + 1];
        } else {
            dataX = new Matrix(rows, cols);
            this.coeffs = new double[cols];
        }
        double[] datay = new double[rows];
        int n = 0;
        int i = 0;
        while (i < rows) {
            int j;
            if (interceptTerm) {
                datay[i] = vectory.elementAt(i);
                dataX.set(i, 0, 1.0);
                j = 1;
                while (j < cols + 1) {
                    dataX.set(i, j, vectorx.elementAt(n++));
                    ++j;
                }
            } else {
                datay[i] = vectory.elementAt(i);
                j = 0;
                while (j < cols) {
                    dataX.set(i, j, vectorx.elementAt(n++));
                    ++j;
                }
            }
            ++i;
        }
        this.multipleLinearRegression(datay, dataX);
        return this.coeffs;
    }

    public double[] multipleLinearRegression(Vector<Double> data, int rows, int cols, boolean interceptTerm) {
        Matrix dataX;
        if (data == null) {
            throw new NullPointerException("Null data");
        }
        if (rows < 0 || cols < 0) {
            throw new IllegalArgumentException("Number of rows and cols must be greater than 0");
        }
        this.b0Term = interceptTerm;
        if (interceptTerm) {
            dataX = new Matrix(rows, cols);
            this.coeffs = new double[cols];
        } else {
            dataX = new Matrix(rows, cols - 1);
            this.coeffs = new double[cols - 1];
        }
        double[] datay = new double[rows];
        int n = 0;
        int i = 0;
        while (i < rows) {
            int j;
            if (interceptTerm) {
                dataX.set(i, 0, 1.0);
                datay[i] = data.elementAt(n++);
                j = 1;
                while (j < cols) {
                    dataX.set(i, j, data.elementAt(n++));
                    ++j;
                }
            } else {
                datay[i] = data.elementAt(n++);
                j = 0;
                while (j < cols - 1) {
                    dataX.set(i, j, data.elementAt(n++));
                    ++j;
                }
            }
            ++i;
        }
        this.multipleLinearRegression(datay, dataX);
        return this.coeffs;
    }

    public void multipleLinearRegression(Matrix datay, Matrix dataX, boolean interceptTerm) {
        this.b0Term = interceptTerm;
        if (interceptTerm) {
            int row = dataX.getRowDimension();
            int col = dataX.getColumnDimension();
            Matrix B = new Matrix(row, col + 1);
            Matrix ones = new Matrix(row, 1);
            int i = 0;
            while (i < row) {
                ones.set(i, 0, 1.0);
                ++i;
            }
            B.setMatrix(0, row - 1, 0, 0, ones);
            B.setMatrix(0, row - 1, 1, col, dataX);
            this.multipleLinearRegression(datay, B);
        } else {
            this.multipleLinearRegression(datay, dataX);
        }
    }

    private void multipleLinearRegression(double[] datay, Matrix dataX) {
        Matrix y = new Matrix(datay, datay.length);
        this.multipleLinearRegression(y, dataX);
    }

    private void multipleLinearRegression(Matrix datay, Matrix dataX) {
        try {
            Matrix X = dataX;
            Matrix y = datay;
            this.b = X.solve(y);
            this.coeffs = new double[this.b.getRowDimension()];
            int j = 0;
            while (j < this.b.getRowDimension()) {
                this.coeffs[j] = this.b.get(j, 0);
                ++j;
            }
            Matrix r = X.times(this.b).minus(y);
            this.residuals = r.getColumnPackedCopy();
            this.rmse = Math.sqrt(MathUtils.sumSquared(this.residuals) / (double)this.residuals.length);
            Matrix p = X.times(this.b);
            this.predictedValues = p.getColumnPackedCopy();
            this.correlation = MathUtils.correlation(this.predictedValues, y.getColumnPackedCopy());
        }
        catch (RuntimeException runtimeException) {
            throw new Error("Error solving Least-square solution: y = X * b");
        }
    }

    public void printCoefficients(int[] indices, String[] factors) {
        if (this.coeffs != null) {
            System.out.println("Linear regression:");
            if (this.b0Term) {
                System.out.format(" %.5f\n", this.coeffs[0]);
                int j = 1;
                while (j < this.coeffs.length) {
                    System.out.format(" %.5f (%s)\n", this.coeffs[j], factors[indices[j - 1]]);
                    ++j;
                }
            } else {
                int j = 0;
                while (j < this.coeffs.length) {
                    System.out.format(" %.5f (%s)\n", this.coeffs[j], factors[indices[j]]);
                    ++j;
                }
            }
        } else {
            System.out.println("There is no coefficients to print.");
        }
    }

    public void printCoefficients() {
        if (this.coeffs != null) {
            int j = 0;
            while (j < this.coeffs.length) {
                System.out.format("coeff[%d]=%.5f\n", j, this.coeffs[j]);
                ++j;
            }
        } else {
            System.out.println("There is no coefficients to print.");
        }
    }

    public void multipleLinearRegression(String fileName, boolean interceptTerm) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            Matrix data = Matrix.read(reader);
            reader.close();
            int rows = data.getRowDimension() - 1;
            int cols = data.getColumnDimension() - 1;
            Matrix indVar = data.getMatrix(0, rows, 0, 0);
            data = data.getMatrix(0, rows, 1, cols);
            this.multipleLinearRegression(indVar, data, interceptTerm);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem reading file " + fileName, e);
        }
    }

    public void multipleLinearRegression(String fileName, int indVariable, int[] c, String[] factors, boolean interceptTerm, int rowIni, int rowEnd) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            Matrix data = Matrix.read(reader);
            reader.close();
            int rows = data.getRowDimension() - 1;
            data.getColumnDimension();
            if (rowIni < 0 || rowIni > rows) {
                throw new RuntimeException("Problem reading file, rowIni=" + rowIni + "  and number of rows in file=" + rows);
            }
            if (rowEnd < 0 || rowEnd > rows) {
                throw new RuntimeException("Problem reading file, rowIni=" + rowIni + "  and number of rows in file=" + rows);
            }
            if (rowIni > rowEnd) {
                throw new RuntimeException("Problem reading file, rowIni < rowend" + rowIni + " < " + rowEnd);
            }
            Matrix indVar = data.getMatrix(rowIni, rowEnd, indVariable, indVariable);
            data = data.getMatrix(rowIni, rowEnd, c);
            this.multipleLinearRegression(indVar, data, interceptTerm);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem reading file " + fileName, e);
        }
    }

    public void predictValues(String fileName, int indVariable, int[] c, boolean interceptTerm, int rowIni, int rowEnd) {
        block11: {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(fileName));
                Matrix data = Matrix.read(reader);
                reader.close();
                int rows = data.getRowDimension() - 1;
                data.getColumnDimension();
                if (rowIni < 0 || rowIni > rows) {
                    throw new RuntimeException("Problem reading file, rowIni=" + rowIni + "  and number of rows in file=" + rows);
                }
                if (rowEnd < 0 || rowEnd > rows) {
                    throw new RuntimeException("Problem reading file, rowIni=" + rowIni + "  and number of rows in file=" + rows);
                }
                if (rowIni > rowEnd) {
                    throw new RuntimeException("Problem reading file, rowIni < rowend" + rowIni + " < " + rowEnd);
                }
                Matrix indVar = data.getMatrix(rowIni, rowEnd, indVariable, indVariable);
                data = data.getMatrix(rowIni, rowEnd, c);
                int numCoeff = interceptTerm ? c.length + 1 : c.length;
                if (this.b != null) {
                    if (this.b.getRowDimension() == numCoeff) {
                        if (interceptTerm) {
                            int row = data.getRowDimension();
                            int col = data.getColumnDimension();
                            Matrix B = new Matrix(row, col + 1);
                            Matrix ones = new Matrix(row, 1);
                            int i = 0;
                            while (i < row) {
                                ones.set(i, 0, 1.0);
                                ++i;
                            }
                            B.setMatrix(0, row - 1, 0, 0, ones);
                            B.setMatrix(0, row - 1, 1, col, data);
                            data = B;
                        }
                        Matrix r = data.times(this.b).minus(indVar);
                        this.residuals = r.getColumnPackedCopy();
                        this.rmse = Math.sqrt(MathUtils.sumSquared(this.residuals) / (double)this.residuals.length);
                        Matrix p = data.times(this.b);
                        this.predictedValues = p.getColumnPackedCopy();
                        int i = 0;
                        while (i < this.predictedValues.length) {
                            if (this.predictedValues[i] < 0.0) {
                                System.out.println("*** WARNING predictedValue < 0.0 : predictedValues[" + i + "]=" + this.predictedValues[i]);
                            }
                            ++i;
                        }
                        this.correlation = MathUtils.correlation(this.predictedValues, indVar.getColumnPackedCopy());
                        System.out.println("Correlation predicted values and real: " + this.correlation);
                        System.out.println("RMSE (root mean square error): " + this.rmse);
                        break block11;
                    }
                    throw new RuntimeException("Number of columns of data is not the same as number of coeficients");
                }
                throw new RuntimeException("Regression coefficients are not loaded");
            }
            catch (Exception e) {
                throw new RuntimeException("Problem reading file " + fileName, e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Regression reg = new Regression();
        double[] yvals = new double[]{25.5, 31.2, 25.9, 38.4, 18.4, 26.7, 26.4, 25.9, 32.0, 25.2, 39.7, 35.7, 26.5};
        double[][] xvals = new double[][]{{1.74, 5.3, 10.8}, {6.32, 5.42, 9.4}, {6.22, 8.41, 7.2}, {10.52, 4.63, 8.5}, {1.19, 11.6, 9.4}, {1.22, 5.85, 9.9}, {4.1, 6.62, 8.0}, {6.32, 8.72, 9.1}, {4.08, 4.42, 8.7}, {4.15, 7.6, 9.2}, {10.15, 4.83, 9.4}, {1.72, 3.12, 7.6}, {1.7, 5.3, 8.2}};
        Matrix A = new Matrix(xvals);
        int row = A.getRowDimension();
        int col = A.getColumnDimension();
        A.print(row, 3);
        Matrix B = new Matrix(row, col + 1);
        Matrix ones = new Matrix(row, 1);
        int i = 0;
        while (i < row) {
            ones.set(i, 0, 1.0);
            ++i;
        }
        B.setMatrix(0, row - 1, 0, 0, ones);
        B.setMatrix(0, row - 1, 1, col, A);
        B.print(row, 3);
        boolean interceptTerm = true;
        reg.multipleLinearRegression(yvals, xvals, interceptTerm);
        reg.printCoefficients();
        Vector<Double> y = new Vector<Double>();
        Vector<Double> x = new Vector<Double>();
        Vector<Double> data = new Vector<Double>();
        double[] array = new double[52];
        int cols = 3;
        int rows = yvals.length;
        int n = 0;
        int i2 = 0;
        while (i2 < rows) {
            y.add(yvals[i2]);
            data.add(yvals[i2]);
            array[n++] = yvals[i2];
            int j = 0;
            while (j < cols) {
                x.add(xvals[i2][j]);
                data.add(xvals[i2][j]);
                array[n++] = xvals[i2][j];
                ++j;
            }
            ++i2;
        }
        System.out.println("Vectors y and x:");
        reg.multipleLinearRegression(y, x, rows, cols, interceptTerm);
        reg.printCoefficients();
        cols = 4;
        rows = yvals.length;
        System.out.println("Vector<> data:");
        reg.multipleLinearRegression(data, rows, cols, interceptTerm);
        reg.printCoefficients();
        System.out.println("Vector array [] data:");
        reg.multipleLinearRegression(array, rows, cols, interceptTerm);
        reg.printCoefficients();
    }
}

