/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.data.tag.CustomTagEntries;
import com.supermartijn642.core.data.tag.CustomTagEntry;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.IOUtils;

public class TagLoader {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final Map<String, Registries.Registry<?>> TAG_TYPES = new HashMap();
    private static final Map<Registries.Registry<?>, Map<ResourceLocation, Set<ResourceLocation>>> TAGS = new HashMap();

    public static void loadTags() {
        for (Registries.Registry<?> registry : TAG_TYPES.values()) {
            TAGS.put(registry, new HashMap());
        }
        Loader.instance().getActiveModList().forEach(TagLoader::loadTags);
        CoreLib.LOGGER.info("Loaded '" + TAGS.get(Registries.BLOCKS).keySet().size() + "' block tags");
        CoreLib.LOGGER.info("Loaded '" + TAGS.get(Registries.ITEMS).keySet().size() + "' item tags");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadTags(ModContainer mod) {
        Path root;
        FileSystem fs;
        block39: {
            File source = mod.getSource();
            if ("minecraft".equals(mod.getModId())) {
                return;
            }
            fs = null;
            root = null;
            if (source.isFile()) {
                try {
                    fs = FileSystems.newFileSystem(source.toPath(), null);
                    root = fs.getPath("/data", new String[0]);
                }
                catch (IOException e) {
                    CoreLib.LOGGER.error("Error loading FileSystem from jar!", (Throwable)e);
                    IOUtils.closeQuietly((Closeable)fs);
                    return;
                }
            } else if (source.isDirectory()) {
                root = source.toPath().resolve("data");
            }
            if (root != null && Files.exists(root, new LinkOption[0])) break block39;
            IOUtils.closeQuietly((Closeable)fs);
            return;
        }
        try {
            List namespaceFolders;
            try (Stream<Path> stream = Files.walk(root, 1, new FileVisitOption[0]);){
                namespaceFolders = stream.filter(Predicate.isEqual(root).negate()).collect(Collectors.toList());
            }
            for (Map.Entry<String, Registries.Registry<?>> tagType : TAG_TYPES.entrySet()) {
                HashMap<ResourceLocation, List<CustomTagEntry>> entries = new HashMap<ResourceLocation, List<CustomTagEntry>>();
                HashMap<ResourceLocation, List<CustomTagEntry>> removeEntries = new HashMap<ResourceLocation, List<CustomTagEntry>>();
                for (Path namespaceFolder : namespaceFolders) {
                    Path tagTypeFolder;
                    Path tagsFolder;
                    String fileName;
                    String namespace;
                    if (!Files.isDirectory(namespaceFolder, new LinkOption[0]) || !RegistryUtil.isValidNamespace(namespace = (fileName = namespaceFolder.getFileName().toString()).endsWith("/") ? fileName.substring(0, fileName.length() - 1) : fileName) || !Files.exists(tagsFolder = namespaceFolder.resolve("tags"), new LinkOption[0]) || !Files.isDirectory(tagsFolder, new LinkOption[0]) || !Files.exists(tagTypeFolder = tagsFolder.resolve(tagType.getKey()), new LinkOption[0]) || !Files.isDirectory(tagTypeFolder, new LinkOption[0])) continue;
                    Stream<Path> paths = Files.walk(tagTypeFolder, new FileVisitOption[0]);
                    Throwable throwable = null;
                    try {
                        paths.forEach(path -> {
                            if (Files.isDirectory(path, new LinkOption[0]) || !path.getFileName().toString().endsWith(".json")) {
                                return;
                            }
                            String identifier = tagTypeFolder.relativize((Path)path).toString();
                            identifier = identifier.substring(0, identifier.length() - ".json".length());
                            if (!RegistryUtil.isValidPath(identifier = identifier.replace('\\', '/'))) {
                                CoreLib.LOGGER.warn("Tag filename '" + namespace + ":" + (String)tagType.getKey() + "/" + identifier + "' from mod '" + mod.getName() + "' contains invalid characters!");
                                return;
                            }
                            ResourceLocation fullIdentifier = new ResourceLocation(namespace, identifier);
                            TagLoader.readTagFile(mod, fullIdentifier, path, (String)tagType.getKey(), (Registries.Registry)tagType.getValue(), entries.computeIfAbsent(fullIdentifier, f -> new ArrayList()), removeEntries.computeIfAbsent(fullIdentifier, f -> new ArrayList()));
                        });
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (paths == null) continue;
                        if (throwable != null) {
                            try {
                                paths.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        paths.close();
                    }
                }
                Stack<ResourceLocation> dependencyStack = new Stack<ResourceLocation>();
                final Registries.Registry<?> registry = tagType.getValue();
                CustomTagEntry.TagEntryResolutionContext<Object> entryResolutionContext = new CustomTagEntry.TagEntryResolutionContext<Object>(){

                    @Override
                    public Object getElement(ResourceLocation identifier) {
                        return registry.getValue(identifier);
                    }

                    @Override
                    public Collection<Object> getTag(ResourceLocation identifier) {
                        return ((Set)((Map)TAGS.get(registry)).get(identifier)).stream().map(registry::getValue).collect(Collectors.toList());
                    }

                    @Override
                    public Collection<Object> getAllElements() {
                        return registry.getValues();
                    }

                    @Override
                    public Set<ResourceLocation> getAllIdentifiers() {
                        return registry.getIdentifiers();
                    }
                };
                while (!entries.isEmpty()) {
                    ResourceLocation tag = (ResourceLocation)entries.keySet().stream().findAny().get();
                    try {
                        TagLoader.resolve(tag, entries, removeEntries, dependencyStack, registry, entryResolutionContext, mod);
                    }
                    catch (JsonParseException e) {
                        CoreLib.LOGGER.error((Object)e);
                    }
                }
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Encountered an exception whilst loading tags for mod '" + mod.getName() + "'!", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fs);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fs);
        return;
    }

    private static void readTagFile(ModContainer mod, ResourceLocation identifier, Path file, String registryName, Registries.Registry<?> registry, Collection<CustomTagEntry> entries, Collection<CustomTagEntry> removeEntries) {
        JsonObject json;
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), StandardCharsets.UTF_8);){
            json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (JsonSyntaxException e) {
            CoreLib.LOGGER.error("Malformed tag json '" + identifier.func_110624_b() + ":" + registryName + "/" + identifier.func_110623_a() + ".json' in mod '" + mod.getName() + "'!", (Throwable)e);
            return;
        }
        Set tagEntries = TAGS.get(registry).computeIfAbsent(identifier, i -> new HashSet());
        try {
            boolean replace;
            if (!(!json.has("replace") || json.get("replace").isJsonPrimitive() && json.get("replace").getAsJsonPrimitive().isBoolean())) {
                throw new RuntimeException("'replace' must be a boolean!");
            }
            boolean bl = replace = json.has("replace") && json.get("replace").getAsBoolean();
            if (replace) {
                tagEntries.clear();
            }
            if (json.has("values")) {
                if (!json.get("values").isJsonArray()) {
                    throw new RuntimeException("'values' must be an array!");
                }
                json.get("values").getAsJsonArray().forEach(element -> entries.add(CustomTagEntries.deserialize(element)));
            }
            if (json.has("remove")) {
                if (!json.get("remove").isJsonArray()) {
                    throw new RuntimeException("'remove' must be an array!");
                }
                json.get("remove").getAsJsonArray().forEach(element -> removeEntries.add(CustomTagEntries.deserialize(element)));
            }
        }
        catch (Exception e) {
            CoreLib.LOGGER.error("Encountered exception in tag json '" + identifier.func_110624_b() + ":" + registryName + "/" + identifier.func_110623_a() + ".json' in mod '" + mod.getName() + "'!", (Throwable)e);
            tagEntries.clear();
            entries.clear();
            removeEntries.clear();
        }
    }

    private static <T> void resolve(ResourceLocation tagIdentifier, Map<ResourceLocation, List<CustomTagEntry>> entries, Map<ResourceLocation, List<CustomTagEntry>> removeEntries, Stack<ResourceLocation> dependencyStack, Registries.Registry<T> registry, CustomTagEntry.TagEntryResolutionContext<T> entryResolutionContext, ModContainer mod) {
        if (dependencyStack.contains(tagIdentifier)) {
            TAGS.get(registry).get(tagIdentifier).clear();
            entries.remove(tagIdentifier);
            removeEntries.remove(tagIdentifier);
            throw new JsonParseException("Mod " + mod.getName() + " has contains a circular tag dependency: " + dependencyStack.stream().map(ResourceLocation::toString).map(s -> "'" + s + "'").collect(Collectors.joining(" -> ")));
        }
        dependencyStack.push(tagIdentifier);
        try {
            for (Map.Entry<ResourceLocation, List<CustomTagEntry>> tag : entries.entrySet()) {
                for (CustomTagEntry entry : tag.getValue()) {
                    HashSet<ResourceLocation> dependencies = new HashSet<ResourceLocation>(entry.getTagDependencies());
                    for (ResourceLocation dependency : dependencies) {
                        if (!entries.containsKey(dependency)) continue;
                        TagLoader.resolve(dependency, entries, removeEntries, dependencyStack, registry, entryResolutionContext, mod);
                    }
                }
            }
        }
        catch (Exception e) {
            TAGS.get(registry).get(tagIdentifier).clear();
            entries.remove(tagIdentifier);
            removeEntries.remove(tagIdentifier);
            dependencyStack.pop();
            throw e;
        }
        try {
            Collection<T> elements;
            for (CustomTagEntry entry : entries.get(tagIdentifier)) {
                elements = entry.resolve(entryResolutionContext);
                if (elements == null) continue;
                TAGS.get(registry).get(tagIdentifier).addAll(elements.stream().map(registry::getIdentifier).collect(Collectors.toList()));
            }
            for (CustomTagEntry entry : removeEntries.get(tagIdentifier)) {
                elements = entry.resolve(entryResolutionContext);
                if (elements == null) continue;
                TAGS.get(registry).get(tagIdentifier).removeAll(elements.stream().map(registry::getIdentifier).collect(Collectors.toList()));
            }
        }
        catch (Exception e) {
            CoreLib.LOGGER.error("Encountered exception in tag json '" + tagIdentifier.func_110624_b() + ":" + registry.getRegistryIdentifier().func_110623_a() + "/" + tagIdentifier.func_110623_a() + ".json' in mod '" + mod.getName() + "'!", (Throwable)e);
            TAGS.get(registry).get(tagIdentifier).clear();
        }
        entries.remove(tagIdentifier);
        removeEntries.remove(tagIdentifier);
        dependencyStack.pop();
    }

    public static Set<ResourceLocation> getTag(Registries.Registry<?> registry, ResourceLocation identifier) {
        return TAGS.containsKey(registry) ? TAGS.get(registry).get(identifier) : null;
    }

    static {
        TAG_TYPES.put("blocks", Registries.BLOCKS);
        TAG_TYPES.put("items", Registries.ITEMS);
    }
}

