/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.generator.GatherDataEvent;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GeneratorRegistrationHandler {
    private static final Map<String, GeneratorRegistrationHandler> REGISTRATION_HELPER_MAP = new HashMap<String, GeneratorRegistrationHandler>();
    private final String modid;
    private final Set<Function<ResourceCache, ResourceGenerator>> generators = new LinkedHashSet<Function<ResourceCache, ResourceGenerator>>();
    private boolean hasEventBeenFired;

    public static synchronized GeneratorRegistrationHandler get(String modid) {
        String activeMod;
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String string = activeMod = Loader.instance().activeModContainer() == null ? null : Loader.instance().activeModContainer().getModId();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + Loader.instance().activeModContainer().getName() + "' is requesting registration helper for different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, GeneratorRegistrationHandler::new);
    }

    private GeneratorRegistrationHandler(String modid) {
        this.modid = modid;
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void handlerGatherDataEvent(GatherDataEvent e) {
                GeneratorRegistrationHandler.this.handlerGatherDataEvent(e);
            }
        });
    }

    public void addGenerator(Function<ResourceCache, ResourceGenerator> generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Generator must not be null!");
        }
        if (this.hasEventBeenFired) {
            throw new RuntimeException("Generators supplier must be added before the GatherDataEvent gets fired!");
        }
        this.generators.add(generator);
    }

    public void addGenerator(Supplier<ResourceGenerator> generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Generator supplier must not be null!");
        }
        this.addGenerator((ResourceCache cache) -> (ResourceGenerator)generator.get());
    }

    public void addGenerator(ResourceGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Generator must not be null!");
        }
        this.addGenerator((ResourceCache cache) -> generator);
    }

    private void handlerGatherDataEvent(GatherDataEvent e) {
        this.hasEventBeenFired = true;
        for (Function<ResourceCache, ResourceGenerator> generatorFunction : this.generators) {
            ResourceGenerator generator = generatorFunction.apply(e.getResourceCache());
            if (generator == null) {
                throw new RuntimeException("Received null generator from a registered generator supplier from mod '" + this.modid + "'!");
            }
            e.addGenerator(generator);
        }
    }
}

