/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc.multiperipheral;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import li.cil.oc.Settings;
import li.cil.oc.api.network.BlacklistedPeripheral;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheral;
import pl.asie.computronics.reference.Config;

@Optional.Interface(iface="li.cil.oc.api.network.BlacklistedPeripheral", modid="opencomputers")
public class MultiPeripheral
implements IPeripheral,
BlacklistedPeripheral {
    private ArrayList<IMultiPeripheral> peripherals;
    private IMultiPeripheral highest;
    private HashMap<String, IMultiPeripheral> methods;
    private String[] methodNames;
    private static Set<Class<?>> blacklist;

    public MultiPeripheral(ArrayList<IMultiPeripheral> peripherals) {
        this.initialize(peripherals);
    }

    private void initialize(ArrayList<IMultiPeripheral> peripherals) {
        this.peripherals = peripherals;
        HashMap<String, IMultiPeripheral> methods = new HashMap<String, IMultiPeripheral>();
        for (IMultiPeripheral peripheral : this.peripherals) {
            String[] names;
            if (this.highest == null || this.highest.peripheralPriority() < peripheral.peripheralPriority()) {
                this.highest = peripheral;
            }
            if ((names = peripheral.getMethodNames()) == null) continue;
            for (String name : names) {
                if (methods.containsKey(name) && peripheral.peripheralPriority() <= ((IMultiPeripheral)methods.get(name)).peripheralPriority()) continue;
                methods.put(name, peripheral);
            }
        }
        ArrayList<String> m = new ArrayList<String>();
        for (String method : methods.keySet()) {
            m.add(method);
        }
        this.methods = methods;
        this.methodNames = m.toArray(new String[m.size()]);
    }

    public String getType() {
        return this.highest.getType();
    }

    public String[] getMethodNames() {
        return (String[])this.methodNames.clone();
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        for (String m : this.methodNames) {
            if (method >= this.methodNames.length || !m.equals(this.methodNames[method])) continue;
            return this.callMethod(this.methods.get(m), computer, context, m, arguments);
        }
        return null;
    }

    private Object[] callMethod(IMultiPeripheral peripheral, IComputerAccess computer, ILuaContext context, String methodName, Object[] arguments) throws LuaException, InterruptedException {
        String[] methods = peripheral.getMethodNames();
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].equals(methodName)) continue;
                return peripheral.callMethod(computer, context, i, arguments);
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
        for (IMultiPeripheral peripheral : this.peripherals) {
            peripheral.attach(computer);
        }
    }

    public void detach(IComputerAccess computer) {
        for (IMultiPeripheral peripheral : this.peripherals) {
            peripheral.detach(computer);
        }
    }

    public boolean equals(IPeripheral other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass().isInstance(other)) {
            MultiPeripheral o = (MultiPeripheral)this.getClass().cast(other);
            if (this.peripherals.size() != o.peripherals.size()) {
                return false;
            }
            for (IPeripheral iPeripheral : this.peripherals) {
                boolean found = false;
                for (IPeripheral iPeripheral2 : o.peripherals) {
                    if (!iPeripheral.equals(iPeripheral2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        for (IMultiPeripheral peripheral : this.peripherals) {
            if (!peripheral.equals(other)) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="opencomputers")
    public boolean isPeripheralBlacklisted() {
        if (!Config.CC_ALL_MULTI_PERIPHERALS) {
            return true;
        }
        boolean blacklisted = true;
        ArrayList<IMultiPeripheral> newPeriphs = new ArrayList<IMultiPeripheral>();
        for (IMultiPeripheral peripheral : this.peripherals) {
            if (this.isBlacklisted(peripheral)) continue;
            blacklisted = false;
            newPeriphs.add(peripheral);
        }
        if (!blacklisted) {
            this.initialize(newPeriphs);
        }
        return blacklisted;
    }

    @Optional.Method(modid="opencomputers")
    private boolean isBlacklisted(Object o) {
        block7: {
            if (o instanceof BlacklistedPeripheral) {
                return ((BlacklistedPeripheral)o).isPeripheralBlacklisted();
            }
            try {
                if (blacklist != null) break block7;
                HashSet newBlacklist = new HashSet();
                for (String name : Settings.get().peripheralBlacklist()) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(name);
                    }
                    catch (ClassNotFoundException e) {
                        clazz = null;
                    }
                    if (clazz == null) continue;
                    newBlacklist.add(clazz);
                }
                blacklist = newBlacklist;
            }
            catch (Exception e) {
                blacklist = new HashSet();
            }
        }
        for (Class<?> clazz : blacklist) {
            if (!clazz.isInstance(o)) continue;
            return true;
        }
        return false;
    }
}

