/*
 * Decompiled with CFR 0.152.
 */
package com.v1993.galacticcomputers.galaxyspace;

import com.v1993.galacticcomputers.utils.NamedManagedEnvironment;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityModernSolarPanel;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverHybridSolarPanel
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return TileEntityModernSolarPanel.class;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing facing) {
        TileEntityModernSolarPanel tile = (TileEntityModernSolarPanel)world.func_175625_s(pos);
        return new InternalManagedEnvironment(tile);
    }

    public static class InternalManagedEnvironment
    extends NamedManagedEnvironment<TileEntityModernSolarPanel> {
        public InternalManagedEnvironment(TileEntityModernSolarPanel tileEntity) {
            super(tileEntity, "solar_panel");
        }

        @Callback(doc="function(): boolean -- Is energy production enabled")
        public Object[] isEnabled(Context context, Arguments args) {
            return new Object[]{!((TileEntityModernSolarPanel)this.tileEntity).getDisabled(0)};
        }

        @Callback(doc="function(boolean: enable) -- Enable/disable energy production")
        public Object[] setEnabled(Context context, Arguments args) {
            ((TileEntityModernSolarPanel)this.tileEntity).setDisabled(0, !args.checkBoolean(0));
            return new Object[0];
        }

        @Callback(doc="function(): number -- Energy being produced per tick")
        public Object[] getEnergyProduction(Context context, Arguments args) {
            return new Object[]{((TileEntityModernSolarPanel)this.tileEntity).generateWatts};
        }

        @Callback(doc="function(): string -- Get current status of solar panel (see docs for possible values)")
        public Object[] getStatus(Context context, Arguments args) {
            if (((TileEntityModernSolarPanel)this.tileEntity).getDisabled(0)) {
                return new Object[]{"DISABLED"};
            }
            if (!((TileEntityModernSolarPanel)this.tileEntity).func_145831_w().func_72935_r()) {
                return new Object[]{"NIGHT_TIME"};
            }
            if (((TileEntityModernSolarPanel)this.tileEntity).func_145831_w().func_72896_J() || ((TileEntityModernSolarPanel)this.tileEntity).func_145831_w().func_72911_I()) {
                return new Object[]{"RAINING"};
            }
            if (((TileEntityModernSolarPanel)this.tileEntity).solarStrength == 0) {
                return new Object[]{"BLOCKED_FULLY"};
            }
            if (((TileEntityModernSolarPanel)this.tileEntity).solarStrength < 9) {
                return new Object[]{"BLOCKED_PARTIALLY"};
            }
            if (((TileEntityModernSolarPanel)this.tileEntity).generateWatts > 0) {
                return new Object[]{"GENERATING"};
            }
            return new Object[]{"UNKNOWN"};
        }

        @Callback(doc="function(): number -- Get solar boost")
        public Object[] getBoost(Context context, Arguments args) {
            return new Object[]{Float.valueOf((float)Math.round((((TileEntityModernSolarPanel)this.tileEntity).getSolarBoost() - 1.0f) * 1000.0f) / 10.0f)};
        }
    }
}

