/*
 * Decompiled with CFR 0.152.
 */
package com.v1993.galacticcomputers.gccore;

import com.v1993.galacticcomputers.utils.NamedManagedEnvironment;
import java.lang.reflect.Method;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverEnergyStorage
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return EnergyStorageTile.class;
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        if (super.worksWith(world, pos, side)) {
            EnergyStorageTile tile = (EnergyStorageTile)world.func_175625_s(pos);
            return tile.getMaxEnergyStoredGC() != 0.0f;
        }
        return false;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing facing) {
        EnergyStorageTile tile = (EnergyStorageTile)world.func_175625_s(pos);
        if (GalacticraftCore.isPlanetsLoaded) {
            try {
                Class<?> fakepad = Class.forName("micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityTelepadFake");
                if (fakepad.isAssignableFrom(tile.getClass())) {
                    Method getBaseTelepad = fakepad.getDeclaredMethod("getBaseTelepad", new Class[0]);
                    getBaseTelepad.setAccessible(true);
                    tile = (EnergyStorageTile)getBaseTelepad.invoke((Object)tile, new Object[0]);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return tile != null ? new InternalManagedEnvironment(tile) : null;
    }

    public static class InternalManagedEnvironment
    extends NamedManagedEnvironment<EnergyStorageTile> {
        public InternalManagedEnvironment(EnergyStorageTile tileEntity) {
            super(tileEntity, "gc_energy_device");
        }

        @Override
        public int priority() {
            return 1;
        }

        @Callback(doc="function(): number -- (GC) Get amount of energy currently stored")
        public Object[] getStoredEnergy(Context context, Arguments args) {
            return new Object[]{Float.valueOf(((EnergyStorageTile)this.tileEntity).getEnergyStoredGC())};
        }

        @Callback(doc="function(): number -- (GC) Get energy capacity of the machine")
        public Object[] getMaxEnergy(Context context, Arguments args) {
            return new Object[]{Float.valueOf(((EnergyStorageTile)this.tileEntity).getMaxEnergyStoredGC())};
        }
    }
}

