/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.transformer.Config;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.asm.ASM;
import zone.rong.mixinbooter.Context;
import zone.rong.mixinbooter.IEarlyMixinLoader;
import zone.rong.mixinbooter.IMixinConfigHijacker;
import zone.rong.mixinbooter.fix.MixinFixer;
import zone.rong.mixinbooter.util.MockedModMetadata;

@IFMLLoadingPlugin.Name(value="MixinBooter")
@IFMLLoadingPlugin.SortingIndex(value=-2147483647)
public final class MixinBooterPlugin
implements IFMLLoadingPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"MixinBooter");
    private static final Map<String, String> presentJarsToMods = new HashMap<String, String>();
    private static final Set<String> presentMods = new HashSet<String>();
    private static final Set<String> unmodifiablePresentMods = Collections.unmodifiableSet(presentMods);
    private static Field modApiManager$dataTable;

    static String getMinecraftVersion() {
        return (String)FMLInjectionData.data()[4];
    }

    public MixinBooterPlugin() {
        this.addTransformationExclusions();
        this.initialize();
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return "zone.rong.mixinbooter.MixinBooterModContainer";
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        Object coremodList = data.get("coremodList");
        if (!(coremodList instanceof List)) {
            throw new RuntimeException("Blackboard property 'coremodList' must be of type List, early loaders were not able to be gathered");
        }
        Collection<IEarlyMixinLoader> earlyLoaders = this.gatherEarlyLoaders((List)coremodList);
        this.loadEarlyLoaders(earlyLoaders);
        this.recordConfigOwners();
    }

    public String getAccessTransformerClass() {
        return null;
    }

    private void addTransformationExclusions() {
        Launch.classLoader.addTransformerExclusion("scala.");
    }

    private void initialize() {
        GlobalProperties.put(GlobalProperties.Keys.CLEANROOM_DISABLE_MIXIN_CONFIGS, new HashSet());
        LOGGER.info("Initializing Mixins...");
        MixinBootstrap.init();
        Mixins.addConfiguration("mixin.mixinbooter.init.json");
        LOGGER.info("Initializing MixinExtras...");
        this.initMixinExtras();
        MixinFixer.patchAncientModMixinsLoadingMethod();
        LOGGER.info("Gathering present mods...");
        this.gatherPresentMods();
        this.afterAll();
    }

    private void initMixinExtras() {
        if (!ASM.isAtLeastVersion(5, 1)) {
            Launch.classLoader.registerTransformer("zone.rong.mixinbooter.fix.mixinextras.MixinExtrasFixer");
        }
        MixinExtrasBootstrap.init();
    }

    private void afterAll() {
        if (unmodifiablePresentMods.contains("spongeforge")) {
            LOGGER.info("Registering SpongeForgeFixer transformer to solve issues pertaining SpongeForge.");
            Launch.classLoader.registerTransformer("zone.rong.mixinbooter.fix.spongeforge.SpongeForgeFixer");
            new PrettyPrinter();
            Launch.classLoader.registerTransformer("zone.rong.mixinbooter.fix.forge.EagerlyLoadEventClassTransformer");
        }
    }

    private void gatherPresentMods() {
        Gson gson = new GsonBuilder().create();
        try {
            Enumeration resources = Launch.classLoader.getResources("mcmod.info");
            while (resources.hasMoreElements()) {
                URL url = (URL)resources.nextElement();
                String fileName = this.getJarNameFromResource(url);
                if (fileName == null) continue;
                List<String> modIds = this.parseMcmodInfo(gson, url);
                if (!modIds.isEmpty()) {
                    presentJarsToMods.put(fileName, modIds.get(0));
                }
                presentMods.addAll(modIds);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to gather present mods", e);
        }
        MixinBooterPlugin.logInfo("Finished gathering %d coremods...", unmodifiablePresentMods.size());
    }

    private String getJarNameFromResource(URL url) {
        String filePath;
        String[] parts;
        if (url.getPath().contains("!/") && (parts = (filePath = url.getPath().split("!/")[0]).split("/")).length != 0) {
            return parts[parts.length - 1];
        }
        return null;
    }

    private List<String> parseMcmodInfo(Gson gson, URL url) {
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(url.openStream()));
            reader.setLenient(true);
            ArrayList<String> ids = new ArrayList<String>();
            for (MockedModMetadata meta : (MockedModMetadata[])gson.fromJson((Reader)new InputStreamReader(url.openStream()), MockedModMetadata[].class)) {
                if (meta.modid == null) continue;
                ids.add(meta.modid);
            }
            return ids;
        }
        catch (Throwable t) {
            MixinBooterPlugin.logError("Failed to parse mcmod.info for %s", t, url);
            return Collections.emptyList();
        }
    }

    private Collection<IEarlyMixinLoader> gatherEarlyLoaders(List coremodList) {
        Field fmlPluginWrapper$coreModInstance = null;
        LinkedHashSet<IEarlyMixinLoader> queuedLoaders = new LinkedHashSet<IEarlyMixinLoader>();
        Collection disabledConfigs = (Collection)GlobalProperties.get(GlobalProperties.Keys.CLEANROOM_DISABLE_MIXIN_CONFIGS);
        Context context = new Context(null, unmodifiablePresentMods);
        for (Object coremod : coremodList) {
            try {
                Object theMod;
                if (fmlPluginWrapper$coreModInstance == null) {
                    fmlPluginWrapper$coreModInstance = coremod.getClass().getField("coreModInstance");
                    fmlPluginWrapper$coreModInstance.setAccessible(true);
                }
                if ((theMod = fmlPluginWrapper$coreModInstance.get(coremod)) instanceof IMixinConfigHijacker) {
                    IMixinConfigHijacker interceptor = (IMixinConfigHijacker)theMod;
                    MixinBooterPlugin.logInfo("Loading config hijacker %s.", interceptor.getClass().getName());
                    for (String hijacked : interceptor.getHijackedMixinConfigs(context)) {
                        disabledConfigs.add(hijacked);
                        MixinBooterPlugin.logInfo("%s will hijack the mixin config %s", interceptor.getClass().getName(), hijacked);
                    }
                }
                if (!(theMod instanceof IEarlyMixinLoader)) continue;
                queuedLoaders.add((IEarlyMixinLoader)theMod);
            }
            catch (Throwable t) {
                LOGGER.error("Unexpected error", t);
            }
        }
        return queuedLoaders;
    }

    private void loadEarlyLoaders(Collection<IEarlyMixinLoader> queuedLoaders) {
        for (IEarlyMixinLoader queuedLoader : queuedLoaders) {
            MixinBooterPlugin.logInfo("Loading early loader %s for its mixins.", queuedLoader.getClass().getName());
            try {
                for (String mixinConfig : queuedLoader.getMixinConfigs()) {
                    Context context = new Context(mixinConfig, unmodifiablePresentMods);
                    if (!queuedLoader.shouldMixinConfigQueue(context)) continue;
                    MixinBooterPlugin.logInfo("Adding [%s] mixin configuration.", mixinConfig);
                    Mixins.addConfiguration(mixinConfig);
                    queuedLoader.onMixinConfigQueued(context);
                }
            }
            catch (Throwable t) {
                MixinBooterPlugin.logError("Failed to execute early loader [%s].", t, queuedLoader.getClass().getName());
            }
        }
    }

    private void recordConfigOwners() {
        for (Config config : Mixins.getConfigs()) {
            if (config.getConfig().hasDecoration("mixinOwner")) continue;
            config.getConfig().decorate("mixinOwner", () -> this.retrieveConfigOwner(config));
        }
    }

    private String retrieveConfigOwner(Config config) {
        String modId;
        String jar;
        if (modApiManager$dataTable == null) {
            try {
                modApiManager$dataTable = ModAPIManager.class.getDeclaredField("dataTable");
                modApiManager$dataTable.setAccessible(true);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Unable to reflectively retrieve ModAPIManager#dataTable", e);
            }
        }
        try {
            ModContainer container;
            String pkg;
            ModCandidate candidate;
            ASMDataTable table = (ASMDataTable)modApiManager$dataTable.get(ModAPIManager.INSTANCE);
            if (table != null && (candidate = (ModCandidate)table.getCandidatesFor(pkg = (pkg = config.getConfig().getMixinPackage()).charAt(pkg.length() - 1) == '.' ? pkg.substring(0, pkg.length() - 1) : pkg).stream().findFirst().orElse(null)) != null && (container = (ModContainer)candidate.getContainedMods().get(0)) != null) {
                return container.getModId();
            }
        }
        catch (IllegalAccessException table) {
            // empty catch block
        }
        URL url = Launch.classLoader.getResource(config.getName());
        if (url != null && (jar = this.getJarNameFromResource(url)) != null && (modId = presentJarsToMods.get(jar)) != null) {
            return modId;
        }
        return "unknown-owner";
    }

    public static void logInfo(String message, Object ... params) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format(message, params));
        }
    }

    public static void logError(String message, Throwable t, Object ... params) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error(String.format(message, params), t);
        }
    }
}

