/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import com.supermartijn642.core.data.condition.ResourceConditions;
import com.supermartijn642.core.registry.Registries;
import net.minecraft.util.ResourceLocation;

public class NotResourceCondition
implements ResourceCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceCondition condition;

    public NotResourceCondition(ResourceCondition condition) {
        this.condition = condition;
    }

    @Override
    public boolean test(ResourceConditionContext context) {
        return !this.condition.test(context);
    }

    @Override
    public ResourceConditionSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements ResourceConditionSerializer<NotResourceCondition> {
        private Serializer() {
        }

        @Override
        public void serialize(JsonObject json, NotResourceCondition condition) {
            JsonObject conditionJson = new JsonObject();
            condition.condition.getSerializer().serialize(conditionJson, condition.condition);
            conditionJson.addProperty("type", ResourceConditions.getIdentifierForSerializer(condition.condition.getSerializer()).toString());
            json.add("condition", (JsonElement)conditionJson);
        }

        @Override
        public NotResourceCondition deserialize(JsonObject json) {
            if (!json.has("condition") || !json.get("condition").isJsonObject()) {
                throw new RuntimeException("Condition must have key 'condition' with a json object!");
            }
            JsonObject conditionJson = json.getAsJsonObject("condition");
            ResourceLocation identifier = new ResourceLocation(conditionJson.get("type").getAsString());
            if (!Registries.RECIPE_CONDITION_SERIALIZERS.hasIdentifier(identifier)) {
                throw new RuntimeException("");
            }
            return new NotResourceCondition((ResourceCondition)ResourceConditions.getSerializerForIdentifier(identifier).deserialize(conditionJson));
        }
    }
}

