/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public interface IOwnable {
    public Owner getOwner();

    public void setOwner(String var1, String var2);

    default public boolean needsValidation() {
        return false;
    }

    default public void onValidate() {
    }

    default public void onOwnerChanged(IBlockState state, World world, BlockPos pos, EntityPlayer player, Owner oldOwner, Owner newOwner) {
        TileEntity te;
        if (this.needsValidation()) {
            this.getOwner().setValidated(false);
            if (player != null) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.universalOwnerChanger.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalOwnerChanger.ownerInvalidated", new Object[0]), TextFormatting.GREEN);
            }
        }
        if ((te = (TileEntity)this) instanceof LinkableBlockEntity) {
            LinkableBlockEntity linkable = (LinkableBlockEntity)te;
            linkable.propagate((ILinkedAction)new ILinkedAction.OwnerChanged(this.getOwner()), linkable);
        }
        te.func_70296_d();
    }

    default public boolean isOwnedBy(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return this.isOwnedBy(new Owner((EntityPlayer)entity));
        }
        return false;
    }

    default public boolean isOwnedBy(Owner otherOwner) {
        Owner self = this.getOwner();
        if (TeamUtils.areOnSameTeam(self, otherOwner)) {
            return true;
        }
        String selfUUID = self.getUUID();
        String otherUUID = otherOwner.getUUID();
        String otherName = otherOwner.getName();
        if (otherUUID != null && otherUUID.equals(selfUUID)) {
            return true;
        }
        return otherName != null && selfUUID.equals("ownerUUID") && otherName.equals(self.getName());
    }

    default public boolean allowsOwnableEntity(Entity entity) {
        Owner beOwner = this.getOwner();
        UUID animalOwnerUUID = null;
        if (!(entity instanceof IEntityOwnable)) {
            return false;
        }
        animalOwnerUUID = ((IEntityOwnable)entity).func_184753_b();
        return animalOwnerUUID != null && (animalOwnerUUID.toString().equals(beOwner.getUUID()) || TeamUtils.areOnSameTeam(beOwner, new Owner(((IEntityOwnable)entity).func_70902_q())));
    }

    default public boolean ignoresOwner() {
        return false;
    }
}

