/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.screen.components.Slider;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class Option<T> {
    private String name;
    protected T value;
    private T defaultValue;
    private T increment;
    private T minimum;
    private T maximum;

    protected Option(String optionName, T value) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
    }

    protected Option(String optionName, T value, T min, T max, T increment) {
        this.name = optionName;
        this.value = value;
        this.defaultValue = value;
        this.increment = increment;
        this.minimum = min;
        this.maximum = max;
    }

    public abstract void toggle();

    public abstract void load(NBTTagCompound var1);

    public abstract void save(NBTTagCompound var1, T var2);

    public void save(NBTTagCompound tag) {
        this.save(tag, this.value);
    }

    public void copy(Option<?> option) {
        this.value = option.get();
    }

    public String getName() {
        return this.name;
    }

    public T get() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getIncrement() {
        return this.increment;
    }

    public T getMin() {
        return this.minimum;
    }

    public T getMax() {
        return this.maximum;
    }

    public boolean isSlider() {
        return false;
    }

    public String getKey(String denotation) {
        return "option." + denotation + "." + this.getName();
    }

    public String getDescriptionKey(String denotation) {
        return this.getKey(denotation) + ".description";
    }

    public ITextComponent getDefaultInfo() {
        return Utils.localize("securitycraft.option.default_with_range", this.getDefaultValue(), this.getMin(), this.getMax()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
    }

    public ITextComponent getValueText() {
        return new TextComponentString(this.toString());
    }

    public String toString() {
        return this.value + "";
    }

    public static class TargetingModeOption
    extends EnumOption<TargetingMode> {
        public TargetingModeOption(TargetingMode defaultValue) {
            super("targetingMode", defaultValue, TargetingMode.class);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.targetingMode";
        }

        @Override
        public ITextComponent getValueText() {
            return ((TargetingMode)((Object)this.value)).translate();
        }
    }

    public static class EnumOption<T extends Enum<T>>
    extends Option<T> {
        private final Class<T> enumClass;

        public EnumOption(String optionName, T value, Class<T> enumClass) {
            super(optionName, value);
            this.enumClass = enumClass;
        }

        @Override
        public void toggle() {
            Enum[] enumConstants = (Enum[])this.enumClass.getEnumConstants();
            int next = (((Enum)this.value).ordinal() + 1) % enumConstants.length;
            this.value = enumConstants[next];
        }

        @Override
        public void load(NBTTagCompound tag) {
            Enum[] enumConstants = (Enum[])this.enumClass.getEnumConstants();
            int ordinal = tag.func_74762_e(this.getName());
            this.value = ordinal >= 0 && ordinal < enumConstants.length ? enumConstants[ordinal] : this.getDefaultValue();
        }

        @Override
        public void save(NBTTagCompound tag, T value) {
            tag.func_74768_a(this.getName(), ((Enum)value).ordinal());
        }

        @Override
        public ITextComponent getValueText() {
            return new TextComponentString(((Enum)this.value).name());
        }

        @Override
        public ITextComponent getDefaultInfo() {
            return Utils.localize("securitycraft.option.default", this.getValueText()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
        }
    }

    public static class DoubleOption
    extends Option<Double>
    implements Slider.ISlider {
        private Supplier<BlockPos> pos;

        public DoubleOption(Supplier<BlockPos> pos, String optionName, Double value, Double min, Double max, Double increment) {
            super(optionName, value, min, max, increment);
            this.pos = pos;
        }

        @Override
        public void toggle() {
        }

        @Override
        public void load(NBTTagCompound tag) {
            this.value = tag.func_74764_b(this.getName()) ? Double.valueOf(tag.func_74769_h(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(NBTTagCompound tag, Double value) {
            tag.func_74780_a(this.getName(), value.doubleValue());
        }

        @Override
        public String toString() {
            return Double.toString((Double)this.value).length() > 5 ? Double.toString((Double)this.value).substring(0, 5) : Double.toString((Double)this.value);
        }

        @Override
        public boolean isSlider() {
            return true;
        }

        @Override
        public void onChangeSliderValue(Slider slider, String denotation, int id) {
            this.setValue(slider.getValue());
            slider.field_146126_j = Utils.localize(this.getKey(denotation), this.toString()).func_150254_d();
        }

        @Override
        public void onMouseRelease(int id) {
            SecurityCraft.network.sendToServer((IMessage)new UpdateSliderValue(this.pos.get(), id, (Double)this.get()));
        }
    }

    public static class SignalLengthOption
    extends IntOption {
        public SignalLengthOption(Supplier<BlockPos> pos, int defaultLength) {
            super(pos, "signalLength", defaultLength, 0, 400, 5);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.signalLength";
        }
    }

    public static class SmartModuleCooldownOption
    extends IntOption {
        public SmartModuleCooldownOption(Supplier<BlockPos> pos) {
            super(pos, "smartModuleCooldown", 100, 20, 400, 1);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.smartModuleCooldown";
        }
    }

    public static class IntOption
    extends Option<Integer>
    implements Slider.ISlider {
        private Supplier<BlockPos> pos;

        public IntOption(Supplier<BlockPos> pos, String optionName, Integer value, Integer min, Integer max, Integer increment) {
            super(optionName, value, min, max, increment);
            this.pos = pos;
        }

        @Override
        public void toggle() {
        }

        @Override
        public void load(NBTTagCompound tag) {
            this.value = tag.func_74764_b(this.getName()) ? Integer.valueOf(tag.func_74762_e(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(NBTTagCompound tag, Integer value) {
            tag.func_74768_a(this.getName(), value.intValue());
        }

        @Override
        public boolean isSlider() {
            return true;
        }

        @Override
        public void onChangeSliderValue(Slider slider, String denotation, int id) {
            this.setValue((int)slider.getValue());
            slider.field_146126_j = Utils.localize(this.getKey(denotation), this.toString()).func_150254_d();
        }

        @Override
        public void onMouseRelease(int id) {
            SecurityCraft.network.sendToServer((IMessage)new UpdateSliderValue(this.pos.get(), id, ((Integer)this.get()).intValue()));
        }
    }

    public static class SendDenylistMessageOption
    extends BooleanOption {
        public SendDenylistMessageOption(Boolean value) {
            super("sendDenylistMessage", value);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.sendDenylistMessage";
        }
    }

    public static class SendAllowlistMessageOption
    extends BooleanOption {
        public SendAllowlistMessageOption(Boolean value) {
            super("sendAllowlistMessage", value);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.sendAllowlistMessage";
        }
    }

    public static class RespectInvisibilityOption
    extends BooleanOption {
        public RespectInvisibilityOption() {
            this(false);
        }

        public RespectInvisibilityOption(Boolean value) {
            super("respectInvisibility", value);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.respectInvisibility";
        }

        public boolean isConsideredInvisible(EntityLivingBase entity) {
            return (Boolean)this.get() != false && entity.func_70644_a(MobEffects.field_76441_p);
        }
    }

    public static class IgnoreOwnerOption
    extends BooleanOption {
        public IgnoreOwnerOption(Boolean value) {
            super("ignoreOwner", value);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.ignoreOwner";
        }
    }

    public static class DisabledOption
    extends BooleanOption {
        public DisabledOption(Boolean value) {
            super("disabled", value);
        }

        @Override
        public String getKey(String denotation) {
            return "option.generic.disabled";
        }
    }

    public static class BooleanOption
    extends Option<Boolean> {
        public BooleanOption(String optionName, Boolean value) {
            super(optionName, value);
        }

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
        }

        @Override
        public void load(NBTTagCompound tag) {
            this.value = tag.func_74764_b(this.getName()) ? Boolean.valueOf(tag.func_74767_n(this.getName())) : this.getDefaultValue();
        }

        @Override
        public void save(NBTTagCompound tag, Boolean value) {
            tag.func_74757_a(this.getName(), value.booleanValue());
        }

        @Override
        public ITextComponent getDefaultInfo() {
            return Utils.localize("securitycraft.option.default", new TextComponentTranslation((Boolean)this.getDefaultValue() != false ? "gui.securitycraft:invScan.yes" : "gui.securitycraft:invScan.no", new Object[0]).func_150254_d()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
        }

        @Override
        public ITextComponent getValueText() {
            return new TextComponentTranslation((Boolean)this.get() != false ? "gui.securitycraft:invScan.yes" : "gui.securitycraft:invScan.no", new Object[0]);
        }
    }
}

