/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ReinforcedSlabsBlock
extends BlockSlab
implements ITileEntityProvider,
IOverlayDisplay,
IReinforcedBlock {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private final boolean isDouble;

    public ReinforcedSlabsBlock(boolean isDouble, Material blockMaterial) {
        super(blockMaterial);
        this.isDouble = isDouble;
        if (!this.func_176552_j()) {
            this.field_149783_u = true;
        }
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.STONE)));
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getColor();
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)SCContent.reinforcedStoneSlabs);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.isDouble) {
            for (EnumType et : EnumType.values()) {
                list.add((Object)new ItemStack((Block)this, 1, et.getMetadata()));
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + EnumType.byMetadata(meta).getTranslationKey();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return EnumType.byMetadata(stack.func_77960_j() & 7);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7))).func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int meta = b0 | ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
        if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            meta |= 8;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public boolean func_176552_j() {
        return this.isDouble;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new OwnableBlockEntity();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(SCContent.reinforcedStoneSlabs, 1, this.func_180651_a(state));
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return new ItemStack(Item.func_150898_a((Block)SCContent.reinforcedStoneSlabs), 1, this.func_176201_c(state) % 8);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return state.func_177230_c() == this;
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(this.isDouble ? Blocks.field_150334_T : Blocks.field_150333_U);
    }

    @Override
    public IBlockState convertToReinforcedState(IBlockState state) {
        EnumType type = null;
        switch ((BlockStoneSlab.EnumType)state.func_177229_b((IProperty)BlockStoneSlab.field_176556_M)) {
            case STONE: {
                type = EnumType.STONE;
                break;
            }
            case SAND: {
                type = EnumType.SANDSTONE;
                break;
            }
            case WOOD: {
                break;
            }
            case COBBLESTONE: {
                type = EnumType.COBBLESTONE;
                break;
            }
            case BRICK: {
                type = EnumType.BRICK;
                break;
            }
            case SMOOTHBRICK: {
                type = EnumType.STONEBRICK;
                break;
            }
            case NETHERBRICK: {
                type = EnumType.NETHERBRICK;
                break;
            }
            case QUARTZ: {
                type = EnumType.QUARTZ;
            }
        }
        if (type != null) {
            IBlockState convertedState = this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)type));
            if (!this.isDouble) {
                convertedState = convertedState.func_177226_a((IProperty)field_176554_a, state.func_177229_b((IProperty)field_176554_a));
            }
            return convertedState;
        }
        return state;
    }

    @Override
    public IBlockState convertToVanillaState(IBlockState state) {
        BlockStoneSlab.EnumType type = null;
        switch ((EnumType)((Object)state.func_177229_b(VARIANT))) {
            case STONE: {
                type = BlockStoneSlab.EnumType.STONE;
                break;
            }
            case COBBLESTONE: {
                type = BlockStoneSlab.EnumType.COBBLESTONE;
                break;
            }
            case SANDSTONE: {
                type = BlockStoneSlab.EnumType.SAND;
                break;
            }
            case STONEBRICK: {
                type = BlockStoneSlab.EnumType.SMOOTHBRICK;
                break;
            }
            case BRICK: {
                type = BlockStoneSlab.EnumType.BRICK;
                break;
            }
            case NETHERBRICK: {
                type = BlockStoneSlab.EnumType.NETHERBRICK;
                break;
            }
            case QUARTZ: {
                type = BlockStoneSlab.EnumType.QUARTZ;
            }
        }
        if (type != null) {
            if (this.isDouble) {
                return Blocks.field_150334_T.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)type).func_177226_a((IProperty)BlockStoneSlab.field_176555_b, (Comparable)Boolean.valueOf(false));
            }
            return Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)type).func_177226_a((IProperty)field_176554_a, state.func_177229_b((IProperty)field_176554_a));
        }
        return state;
    }

    @Override
    public ItemStack convertToReinforcedStack(ItemStack stackToConvert, Block blockToConvert) {
        if (!this.isDouble) {
            switch (stackToConvert.func_77960_j()) {
                case 0: {
                    return new ItemStack((Block)this, 1, 0);
                }
                case 1: {
                    return new ItemStack((Block)this, 1, 2);
                }
                case 3: {
                    return new ItemStack((Block)this, 1, 1);
                }
                case 4: {
                    return new ItemStack((Block)this, 1, 4);
                }
                case 5: {
                    return new ItemStack((Block)this, 1, 3);
                }
                case 6: {
                    return new ItemStack((Block)this, 1, 5);
                }
                case 7: {
                    return new ItemStack((Block)this, 1, 6);
                }
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack convertToVanillaStack(ItemStack stackToConvert) {
        switch (stackToConvert.func_77960_j()) {
            case 0: {
                return new ItemStack((Block)this, 1, 0);
            }
            case 1: {
                return new ItemStack((Block)this, 1, 3);
            }
            case 2: {
                return new ItemStack((Block)this, 1, 1);
            }
            case 3: {
                return new ItemStack((Block)this, 1, 5);
            }
            case 4: {
                return new ItemStack((Block)this, 1, 4);
            }
            case 5: {
                return new ItemStack((Block)this, 1, 6);
            }
            case 6: {
                return new ItemStack((Block)this, 1, 7);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static enum EnumType implements IStringSerializable
    {
        STONE(0, "stone", "stone", MapColor.field_151665_m),
        COBBLESTONE(1, "cobblestone", "cobble", MapColor.field_151665_m),
        SANDSTONE(2, "sandstone", "sandstone", MapColor.field_151658_d),
        STONEBRICK(3, "stonebrick", "stonebrick", MapColor.field_151665_m),
        BRICK(4, "brick", "brick", MapColor.field_151645_D),
        NETHERBRICK(5, "netherbrick", "netherbrick", MapColor.field_151655_K),
        QUARTZ(6, "quartz", "quartz", MapColor.field_151677_p);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;
        private final MapColor color;

        private EnumType(int meta, String name, String unlocalizedName, MapColor color) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
            this.color = color;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getTranslationKey() {
            return this.unlocalizedName;
        }

        public MapColor getColor() {
            return this.color;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] values = EnumType.values();
            int length = values.length;
            for (int i = 0; i < length; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = values[i];
            }
        }
    }
}

