/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ItemContainer
implements IInventory {
    private final ItemStack containerStack;
    private final NonNullList<ItemStack> inventory;
    private final int maxStackSize;

    private ItemContainer(ItemStack containerStack, int inventorySize, int maxStackSize) {
        this.containerStack = containerStack;
        this.maxStackSize = maxStackSize;
        this.inventory = NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
        if (!containerStack.func_77942_o()) {
            containerStack.func_77982_d(new NBTTagCompound());
        }
        this.load(containerStack.func_77978_p());
    }

    public static ItemContainer briefcase(ItemStack briefcase) {
        return new ItemContainer(briefcase, 12, 64);
    }

    public static ItemContainer keycardHolder(ItemStack keycardHolder) {
        return new ItemContainer(keycardHolder, 5, 1);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public void load(NBTTagCompound tag) {
        NBTTagList items = tag.func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot >= this.func_70302_i_()) continue;
            this.inventory.set(slot, (Object)new ItemStack(item));
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a("Slot", i);
            this.func_70301_a(i).func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        tag.func_74782_a("ItemInventory", (NBTBase)items);
    }

    public ItemStack func_70298_a(int index, int size) {
        ItemStack stack = this.func_70301_a(index);
        if (!stack.func_190926_b()) {
            if (stack.func_190916_E() > size) {
                stack = stack.func_77979_a(size);
                this.func_70296_d();
            } else {
                this.func_70299_a(index, ItemStack.field_190927_a);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return stack;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        this.inventory.set(index, (Object)itemStack);
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.containerStack.func_82833_r();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return this.maxStackSize;
    }

    public void func_70296_d() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b() || this.func_70301_a(i).func_190916_E() != 0) continue;
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
        }
        this.writeToNBT(this.containerStack.func_77978_p());
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack itemStack) {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

