/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.items.LensItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.util.BlockEntityRenderDelegate;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class SecurityCameraRenderer
extends TileEntitySpecialRenderer<SecurityCameraBlockEntity> {
    private static final SecurityCameraModel MODEL = new SecurityCameraModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/blocks/security_camera.png");
    private static final ResourceLocation BEING_VIEWED_TEXTURE = new ResourceLocation("securitycraft:textures/blocks/security_camera_viewing.png");

    public void render(SecurityCameraBlockEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().func_175606_aa().func_180425_c().func_177977_b().equals((Object)te.func_174877_v())) {
            return;
        }
        BlockEntityRenderDelegate.DISGUISED_BLOCK.tryRenderDelegate(te, x, y, z, partialTicks, destroyStage, alpha);
        if (te.isDown()) {
            return;
        }
        if (!te.isModuleEnabled(ModuleType.DISGUISE)) {
            IBlockState state;
            float rotation = -10000.0f;
            if (te.func_145830_o()) {
                Tessellator tessellator = Tessellator.func_178181_a();
                float brightness = te.func_145831_w().func_175724_o(te.func_174877_v());
                int skyBrightness = te.func_145831_w().func_175626_b(te.func_174877_v(), 0);
                int lightmapX = skyBrightness % 65536;
                int lightmapY = skyBrightness / 65536;
                tessellator.func_178180_c().putColorRGBA(0, (int)(brightness * 255.0f), (int)(brightness * 255.0f), (int)(brightness * 255.0f), 255);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapX, (float)lightmapY);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
            Minecraft.func_71410_x().field_71446_o.func_110577_a(te.isSomeoneViewing() ? BEING_VIEWED_TEXTURE : TEXTURE);
            GlStateManager.func_179094_E();
            if (te.func_145830_o() && (state = te.func_145831_w().func_180495_p(te.func_174877_v())).func_177230_c() == SCContent.securityCamera) {
                EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)SecurityCameraBlock.FACING);
                if (side == EnumFacing.EAST) {
                    rotation = -1.0f;
                } else if (side == EnumFacing.WEST) {
                    rotation = 1.0f;
                } else if (side == EnumFacing.NORTH) {
                    rotation = 0.0f;
                }
            }
            GlStateManager.func_179114_b((float)180.0f, (float)rotation, (float)0.0f, (float)1.0f);
            MODEL.rotateCameraY((float)Utils.lerp((double)partialTicks, te.getOriginalCameraRotation(), te.getCameraRotation()));
            if (te.isShutDown()) {
                MODEL.rotateCameraX(0.9f);
            } else {
                MODEL.rotateCameraX(0.2617994f);
            }
            ItemStack lens = te.getLensContainer().func_70301_a(0);
            Item item = lens.func_77973_b();
            if (item instanceof LensItem && ((LensItem)item).hasColor(lens)) {
                int color = ((LensItem)item).getColor(lens);
                SecurityCameraRenderer.MODEL.r = (float)(color >> 16 & 0xFF) / 255.0f;
                SecurityCameraRenderer.MODEL.g = (float)(color >> 8 & 0xFF) / 255.0f;
                SecurityCameraRenderer.MODEL.b = (float)(color & 0xFF) / 255.0f;
            } else {
                SecurityCameraRenderer.MODEL.r = 0.4392157f;
                SecurityCameraRenderer.MODEL.g = 1.0f;
                SecurityCameraRenderer.MODEL.b = 1.0f;
                SecurityCameraRenderer.MODEL.cameraRotationPoint2.field_78807_k = true;
            }
            MODEL.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            SecurityCameraRenderer.MODEL.cameraRotationPoint2.field_78807_k = false;
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }
}

