/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.network.server.SyncSecureRedstoneInterface;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.screen.components.Slider;
import net.geforcemods.securitycraft.screen.components.StringHoverChecker;
import net.geforcemods.securitycraft.screen.components.ToggleComponentButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SecureRedstoneInterfaceScreen
extends GuiScreen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/secure_redstone_interface.png");
    private static final ResourceLocation RANDOM_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/random.png");
    private static final ResourceLocation RANDOM_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/random_inactive.png");
    private final String frequencyText = new TextComponentTranslation("gui.securitycraft:secure_redstone_interface.frequency", new Object[0]).func_150254_d();
    private final SecureRedstoneInterfaceBlockEntity be;
    private final boolean oldSender;
    private final boolean oldProtectedSignal;
    private final boolean oldSendExactPower;
    private final boolean oldReceiveInvertedPower;
    private final boolean oldHighlightConnections;
    private final int oldFrequency;
    private final int oldSenderRange;
    private final int xSize = 176;
    private final int ySize = 188;
    private final String title;
    private int leftPos;
    private int topPos;
    private GuiTextField frequencyBox;
    private StringHoverChecker[] hoverCheckers = new StringHoverChecker[3];
    private boolean sync = true;

    public SecureRedstoneInterfaceScreen(SecureRedstoneInterfaceBlockEntity be) {
        this(be, be.isSender(), be.isProtectedSignal(), be.getFrequency(), be.sendsExactPower(), be.receivesInvertedPower(), be.getSenderRange(), be.shouldHighlightConnections());
    }

    private SecureRedstoneInterfaceScreen(SecureRedstoneInterfaceBlockEntity be, boolean oldSender, boolean oldProtectedSignal, int oldFrequency, boolean oldSendExactPower, boolean oldReceiveInvertedPower, int oldSenderRange, boolean oldHighlightConnections) {
        this.title = be.func_145748_c_().func_150254_d();
        this.be = be;
        this.oldSender = oldSender;
        this.oldProtectedSignal = oldProtectedSignal;
        this.oldFrequency = oldFrequency;
        this.oldSendExactPower = oldSendExactPower;
        this.oldReceiveInvertedPower = oldReceiveInvertedPower;
        this.oldSenderRange = oldSenderRange;
        this.oldHighlightConnections = oldHighlightConnections;
    }

    public void func_73866_w_() {
        int widgetWidth = 150;
        int widgetHeight = 20;
        int id = 0;
        int hoverCheckerId = 0;
        super.func_73866_w_();
        this.leftPos = (this.field_146294_l - 176) / 2;
        this.topPos = (this.field_146295_m - 188) / 2;
        String powerSettingKey = "gui.securitycraft:secure_redstone_interface." + (this.be.isSender() ? "send_exact_power" : "receive_inverted_power");
        int widgetX = this.leftPos + 13;
        int widgetY = this.topPos + 38;
        GuiPageButtonList.GuiResponder frequencyBoxResponder = new GuiPageButtonList.GuiResponder(){

            public void func_175319_a(int id, String s) {
                if (!s.isEmpty()) {
                    SecureRedstoneInterfaceScreen.this.be.setFrequency(Integer.parseInt(s));
                } else {
                    SecureRedstoneInterfaceScreen.this.be.setFrequency(0);
                }
            }

            public void func_175320_a(int id, float value) {
            }

            public void func_175321_a(int id, boolean value) {
            }
        };
        this.frequencyBox = new GuiTextField(id++, this.field_146289_q, widgetX, widgetY, widgetWidth - 23, widgetHeight);
        this.frequencyBox.func_146185_a(true);
        this.frequencyBox.func_146180_a(this.be.getFrequency() + "");
        this.frequencyBox.func_146203_f(9);
        this.frequencyBox.func_175205_a(s -> s.matches("\\d*"));
        this.frequencyBox.func_175207_a(frequencyBoxResponder);
        this.func_189646_b((GuiButton)new PictureButton(id++, widgetX + widgetWidth - 20, widgetY, 20, widgetHeight, RANDOM_INACTIVE_TEXTURE, 16, 16, 3, 3, 16, 16, 16, 16, b -> {
            String newText = "" + SecurityCraft.RANDOM.nextInt(999999999);
            this.frequencyBox.func_146180_a(newText);
            frequencyBoxResponder.func_175319_a(this.frequencyBox.func_175206_d(), newText);
        }){

            @Override
            public ResourceLocation getTextureLocation() {
                return this.field_146124_l ? RANDOM_TEXTURE : RANDOM_INACTIVE_TEXTURE;
            }
        });
        this.func_189646_b((GuiButton)new ToggleComponentButton(id++, widgetX, widgetY += 23, widgetWidth, widgetHeight, i -> this.formatButtonText("gui.securitycraft:secure_redstone_interface.mode", "gui.securitycraft:secure_redstone_interface.mode." + (i == 0 ? "sender" : "receiver")), this.initial(this.be.isSender()), 2, button -> {
            boolean isNowASender = !this.be.isSender();
            this.be.setSender(isNowASender);
            if (isNowASender) {
                this.be.setReceiveInvertedPower(this.oldReceiveInvertedPower);
            } else {
                this.be.setProtectedSignal(this.oldProtectedSignal);
                this.be.setSendExactPower(this.oldSendExactPower);
                this.be.setSenderRange(this.oldSenderRange);
            }
            this.sync = false;
            this.field_146297_k.func_147108_a((GuiScreen)new SecureRedstoneInterfaceScreen(this.be, this.oldSender, this.oldProtectedSignal, this.oldFrequency, this.oldSendExactPower, this.oldReceiveInvertedPower, this.oldSenderRange, this.oldHighlightConnections));
        }));
        GuiButton powerSettingButton = this.func_189646_b((GuiButton)new ToggleComponentButton(id++, widgetX, widgetY += 23, widgetWidth, widgetHeight, i -> this.formatButtonText(powerSettingKey, this.yesOrNo(i)), this.initial(this.be.isSender() ? this.be.sendsExactPower() : this.be.receivesInvertedPower()), 2, button -> {
            if (this.be.isSender()) {
                this.be.setSendExactPower(!this.be.sendsExactPower());
            } else {
                this.be.setReceiveInvertedPower(!this.be.receivesInvertedPower());
            }
        }));
        this.hoverCheckers[hoverCheckerId++] = new StringHoverChecker(powerSettingButton, this.yesOrNoTooltip(powerSettingKey + ".tooltip"));
        if (this.be.isSender()) {
            GuiButton protectedSignalButton = this.func_189646_b((GuiButton)new ToggleComponentButton(id++, widgetX, widgetY += 23, widgetWidth, widgetHeight, i -> this.formatButtonText("gui.securitycraft:secure_redstone_interface.protected_signal", this.yesOrNo(i)), this.initial(this.be.isProtectedSignal()), 2, button -> this.be.setProtectedSignal(!this.be.isProtectedSignal())));
            this.hoverCheckers[hoverCheckerId++] = new StringHoverChecker(protectedSignalButton, this.yesOrNoTooltip("gui.securitycraft:secure_redstone_interface.protected_signal.tooltip"));
            this.func_189646_b((GuiButton)new Slider(Utils.localize("gui.securitycraft:projector.range", this.be.getSenderRange()).func_150254_d(), Utils.getLanguageKeyDenotation(SCContent.secureRedstoneInterface), id++, widgetX, widgetY += 23, widgetWidth, widgetHeight, Utils.localize("gui.securitycraft:projector.range", "").func_150254_d(), 1.0, 64.0, this.be.getSenderRange(), true, new Slider.ISlider(){

                @Override
                public void onMouseRelease(int id) {
                }

                @Override
                public void onChangeSliderValue(Slider slider, String denotation, int id) {
                    int value = slider.getValueInt();
                    SecureRedstoneInterfaceScreen.this.be.setSenderRange(value);
                    slider.field_146126_j = Utils.localize("gui.securitycraft:projector.range", value).func_150254_d();
                }
            }));
        }
        GuiButton highlightButton = this.func_189646_b((GuiButton)new ToggleComponentButton(id++, widgetX, widgetY += 23, widgetWidth, widgetHeight, i -> this.formatButtonText("gui.securitycraft:secure_redstone_interface.highlight_connections", this.yesOrNo(i)), this.initial(this.be.shouldHighlightConnections()), 2, button -> this.be.setHighlightConnections(!this.be.shouldHighlightConnections())));
        this.hoverCheckers[hoverCheckerId] = new StringHoverChecker(highlightButton, Arrays.asList(Utils.localize("gui.securitycraft:secure_redstone_interface.highlight_connections.tooltip", new Object[0]).func_150254_d().split("/n")));
        this.hoverCheckers[hoverCheckerId].singleTooltip();
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.leftPos, this.topPos, 0, 0, 176, 188);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.frequencyBox.func_146194_f();
        this.field_146289_q.func_78276_b(this.frequencyText, this.frequencyBox.field_146209_f, this.frequencyBox.field_146210_g - this.field_146289_q.field_78288_b - 1, 0x404040);
        this.field_146289_q.func_78276_b(this.title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(this.title) / 2, this.topPos + 6, 0x404040);
        for (StringHoverChecker thc : this.hoverCheckers) {
            if (thc == null || !thc.checkHover(mouseX, mouseY)) continue;
            if (thc.isSingleTooltip()) {
                this.func_146283_a(thc.getLines(), mouseX, mouseY);
                break;
            }
            this.func_146279_a(thc.getName(), mouseX, mouseY);
            break;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode != 1 && this.frequencyBox.func_146206_l()) {
            this.frequencyBox.func_146201_a(typedChar, keyCode);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
        if (this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.frequencyBox.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.sync) {
            boolean sender = this.be.isSender();
            boolean protectedSignal = this.be.isProtectedSignal();
            int frequency = this.be.getFrequency();
            boolean sendsExactPower = this.be.sendsExactPower();
            boolean receivesInvertedPower = this.be.receivesInvertedPower();
            int senderRange = this.be.getSenderRange();
            boolean highlightConnections = this.be.shouldHighlightConnections();
            if (sender != this.oldSender || protectedSignal != this.oldProtectedSignal || frequency != this.oldFrequency || sendsExactPower != this.oldSendExactPower || receivesInvertedPower != this.oldReceiveInvertedPower || senderRange != this.oldSenderRange || highlightConnections != this.oldHighlightConnections) {
                SecurityCraft.network.sendToServer((IMessage)new SyncSecureRedstoneInterface(this.be.func_174877_v(), sender, protectedSignal, frequency, sendsExactPower, receivesInvertedPower, senderRange, highlightConnections));
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private String formatButtonText(String message, String value) {
        return Utils.localize("securitycraft.generic_value", Utils.localize(message, new Object[0]), Utils.localize(value, new Object[0])).func_150254_d();
    }

    private String yesOrNo(int index) {
        return "gui.securitycraft:invScan." + (index == 0 ? "yes" : "no");
    }

    private List<String> yesOrNoTooltip(String key) {
        return Arrays.asList(Utils.localize(key + ".true", new Object[0]).func_150254_d(), Utils.localize(key + ".false", new Object[0]).func_150254_d());
    }

    private int initial(boolean value) {
        return value ? 0 : 1;
    }
}

