/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.geforcemods.securitycraft.screen.components.ColorableScrollPanel;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldNameable;

public class SSSConnectionList<T extends GuiScreen>
extends ColorableScrollPanel {
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private final T parent;
    private final List<ConnectionInfo> connectionInfo = new ArrayList<ConnectionInfo>();
    private final FontRenderer font;

    public SSSConnectionList(T parent, Minecraft client, int width, int height, int top, int left) {
        super(client, width, height, top, left);
        this.parent = parent;
        this.font = client.field_71466_p;
        this.refreshPositions();
    }

    public void refreshPositions() {
        WorldClient level = Minecraft.func_71410_x().field_71441_e;
        this.connectionInfo.clear();
        for (BlockPos pos : ((ConnectionAccessor)this.parent).getPositions()) {
            TileEntity be = level.func_175625_s(pos);
            String blockName = be instanceof IWorldNameable ? ((IWorldNameable)be).func_145748_c_().func_150254_d() : (be != null ? Utils.localize(level.func_180495_p(pos).func_177230_c(), new Object[0]).func_150254_d() : "????");
            this.connectionInfo.add(new ConnectionInfo(pos, blockName));
        }
    }

    @Override
    public int getContentHeight() {
        int height = this.connectionInfo.size() * 12;
        if (height < this.bottom - this.top - 4) {
            height = this.bottom - this.top - 4;
        }
        return height;
    }

    @Override
    public int getSize() {
        return this.connectionInfo.size();
    }

    @Override
    public void drawPanel(int entryRight, int relativeY, Tessellator tesselator, int mouseX, int mouseY) {
        int slotBuffer = this.slotHeight - 4;
        int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 2.0f);
        int slotIndex = mouseListY / this.slotHeight;
        if (mouseX >= this.left && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.connectionInfo.size() && mouseY >= this.top && mouseY <= this.bottom) {
            int min = this.left;
            int max = entryRight - 6;
            int slotTop = relativeY + slotIndex * this.slotHeight;
            BufferBuilder bufferBuilder = tesselator.func_178180_c();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferBuilder.func_181662_b((double)min, (double)(slotTop + slotBuffer + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)max, (double)(slotTop + slotBuffer + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)max, (double)(slotTop - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)min, (double)(slotTop - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)(max - 1), (double)(slotTop - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferBuilder.func_181662_b((double)(min + 1), (double)(slotTop - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tesselator.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(BEACON_GUI);
            Gui.func_152125_a((int)this.left, (int)(slotTop - 3), (float)110.0f, (float)219.0f, (int)21, (int)22, (int)14, (int)14, (float)256.0f, (float)256.0f);
        }
        int i = 0;
        for (ConnectionInfo info : this.connectionInfo) {
            int yStart = relativeY + this.slotHeight * i++;
            this.font.func_78276_b(info.blockName, this.left + 13, yStart, 0xC6C6C6);
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY) {
        super.drawScreen(mouseX, mouseY);
        int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - 2.0f);
        int slotIndex = mouseListY / this.slotHeight;
        if (slotIndex >= 0 && slotIndex < this.connectionInfo.size() && mouseListY >= 0 && mouseX >= this.left && mouseX < this.right - 6 && mouseY >= this.top && mouseY <= this.bottom) {
            String blockName = this.connectionInfo.get(slotIndex).blockName;
            int length = this.font.func_78256_a(blockName);
            int baseY = this.top + 4 - (int)this.scrollDistance;
            if (length + 13 >= this.listWidth - 6) {
                this.parent.func_146279_a(blockName, this.left + 1, baseY + (this.slotHeight * slotIndex + this.slotHeight));
                GlStateManager.func_179140_f();
            }
            this.font.func_78276_b(Utils.getFormattedCoordinates(this.connectionInfo.get(slotIndex).pos).func_150254_d(), this.left + 13, this.top + this.listHeight + 5, 0x404040);
        }
    }

    @Override
    public void elementClicked(int mouseX, int mouseY, int slotIndex) {
        if (mouseX < this.left + 13) {
            ((ConnectionAccessor)this.parent).removePosition(this.connectionInfo.get(slotIndex).pos);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    private class ConnectionInfo {
        private final BlockPos pos;
        private final String blockName;

        public ConnectionInfo(BlockPos pos, String blockName) {
            this.pos = pos;
            this.blockName = blockName;
        }
    }

    public static interface ConnectionAccessor {
        public Set<BlockPos> getPositions();

        public void removePosition(BlockPos var1);
    }
}

