/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.compat.ftbutilities.FTBUtilitiesCompat;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamHandler;
import net.geforcemods.securitycraft.util.VanillaTeamHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;

public class TeamUtils {
    private static List<TeamHandler> teamPrecedence;

    private TeamUtils() {
    }

    public static boolean areOnSameTeam(Owner owner1, Owner owner2) {
        if (owner1.equals(owner2)) {
            return true;
        }
        if (!ConfigHandler.enableTeamOwnership) {
            return false;
        }
        for (TeamHandler teamHandler : teamPrecedence) {
            if (!teamHandler.areOnSameTeam(owner1, owner2)) continue;
            return true;
        }
        return false;
    }

    public static ScorePlayerTeam getVanillaTeamFromPlayer(String playerName) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            return server.func_130014_f_().func_96441_U().func_96509_i(playerName);
        }
        return SecurityCraft.proxy.getClientPlayer().field_70170_p.func_96441_U().func_96509_i(playerName);
    }

    public static TeamRepresentation getTeamRepresentation(Owner owner) {
        if (ConfigHandler.enableTeamOwnership) {
            for (TeamHandler teamHandler : teamPrecedence) {
                TeamRepresentation teamRepresentation = teamHandler.getTeamRepresentation(owner);
                if (teamRepresentation == null) continue;
                return teamRepresentation;
            }
        }
        return null;
    }

    public static Collection<EntityPlayerMP> getOnlinePlayersFromOwner(MinecraftServer server, Owner owner) {
        if (ConfigHandler.enableTeamOwnership) {
            for (TeamHandler teamHandler : teamPrecedence) {
                Collection<EntityPlayerMP> onlinePlayers = teamHandler.getOnlinePlayersFromOwner(server, owner);
                if (onlinePlayers == null || onlinePlayers.isEmpty()) continue;
                return onlinePlayers;
            }
        }
        return PlayerUtils.getPlayerListFromOwner(owner);
    }

    public static void setPrecedence(List<TeamHandler> list) {
        teamPrecedence = list;
    }

    public static enum TeamType {
        FTB_TEAMS(() -> {
            if (Loader.isModLoaded((String)"ftbteams")) {
                return new FTBUtilitiesCompat();
            }
            return null;
        }),
        VANILLA(VanillaTeamHandler::new),
        NO_OP(() -> null);

        private final Supplier<TeamHandler> teamHandler;

        private TeamType(Supplier<TeamHandler> teamHandler) {
            this.teamHandler = teamHandler;
        }

        public TeamHandler getTeamHandler() {
            return this.teamHandler.get();
        }
    }

    public static class TeamRepresentation {
        private final String name;
        private final TextFormatting color;

        public TeamRepresentation(String name, TextFormatting color) {
            this.name = name;
            this.color = color;
        }

        public String name() {
            return this.name;
        }

        public TextFormatting color() {
            return this.color;
        }
    }
}

