/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.network;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import mod.casinocraft.network.MessageScoreClient;
import mod.casinocraft.system.CasinoPacketHandler;
import mod.casinocraft.tileentities.TileEntityBoard;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageScoreServer
implements IMessage {
    int points;
    String names;
    int length;
    int x;
    int y;
    int z;

    public MessageScoreServer() {
    }

    public MessageScoreServer(String scoreName, int scorePoints, BlockPos pos) {
        this.points = scorePoints;
        this.names = scoreName;
        this.length = scoreName.length();
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.points);
        buf.writeInt(this.length);
        buf.writeCharSequence((CharSequence)this.names, Charset.defaultCharset());
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.points = buf.readInt();
            this.length = buf.readInt();
            this.names = (String)buf.readCharSequence(this.length, Charset.defaultCharset());
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Handler
    implements IMessageHandler<MessageScoreServer, IMessage> {
        public IMessage onMessage(MessageScoreServer message, MessageContext context) {
            EntityPlayerMP serverPlayer = context.getServerHandler().field_147369_b;
            BlockPos pos = new BlockPos(message.x, message.y, message.z);
            TileEntityBoard te = (TileEntityBoard)context.getServerHandler().field_147369_b.field_70170_p.func_175625_s(pos);
            serverPlayer.func_71121_q().func_152344_a(() -> {
                te.LOGIC.addScore(message.names, message.points);
                te.LOGIC.resetPlayers();
            });
            CasinoPacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageScoreClient(message.names, message.points, pos), new NetworkRegistry.TargetPoint(context.getServerHandler().field_147369_b.field_71093_bK, (double)message.x, (double)message.y, (double)message.z, 64.0));
            return null;
        }
    }
}

