/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.api.layered;

import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Easing;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class KeyframeAnimationPlayer
implements IAnimation {
    private final KeyframeAnimation data;
    private boolean isRunning = true;
    private int currentTick;
    private boolean isLoopStarted = false;
    protected float tickDelta;
    public final HashMap<String, BodyPart> bodyParts;
    public int perspective = 0;

    public KeyframeAnimationPlayer(KeyframeAnimation emote, int t, boolean mutable) {
        if (emote == null) {
            throw new IllegalArgumentException("Animation can not be null");
        }
        this.data = emote;
        this.bodyParts = new HashMap(emote.getBodyParts().size());
        for (Map.Entry<String, KeyframeAnimation.StateCollection> part : emote.getBodyParts().entrySet()) {
            this.bodyParts.put(part.getKey(), new BodyPart(mutable ? part.getValue().copy() : part.getValue()));
        }
        this.currentTick = t;
        if (this.isInfinite() && t > this.data.returnToTick) {
            this.currentTick = (t - this.data.returnToTick) % (this.data.endTick - this.data.returnToTick + 1) + this.data.returnToTick;
        }
    }

    public KeyframeAnimationPlayer(KeyframeAnimation emote, int t) {
        this(emote, t, false);
    }

    public KeyframeAnimationPlayer(KeyframeAnimation animation) {
        this(animation, 0);
    }

    @Override
    public void tick() {
        if (this.isRunning) {
            ++this.currentTick;
            if (this.data.isInfinite && this.currentTick > this.data.endTick) {
                this.currentTick = this.data.returnToTick;
                this.isLoopStarted = true;
            }
            if (this.currentTick >= this.data.stopTick) {
                this.stop();
            }
        }
    }

    public int getTick() {
        return this.currentTick;
    }

    public void stop() {
        this.isRunning = false;
    }

    @Override
    public boolean isActive() {
        return this.isRunning;
    }

    @Override
    public Vec3f get3DTransform(String modelName, TransformType type, float tickDelta, Vec3f value0) {
        BodyPart part = this.bodyParts.get(modelName);
        if (part == null) {
            return value0;
        }
        switch (type) {
            case POSITION: {
                return part.getBodyOffset(value0);
            }
            case ROTATION: {
                Vec3f rot = part.getBodyRotation(value0);
                return new Vec3f(((Float)rot.getX()).floatValue(), ((Float)rot.getY()).floatValue(), ((Float)rot.getZ()).floatValue());
            }
            case BEND: {
                Pair<Float, Float> bend = part.getBend(new Pair<Float, Float>((Float)value0.getX(), (Float)value0.getY()));
                return new Vec3f(bend.getLeft().floatValue(), bend.getRight().floatValue(), 0.0f);
            }
        }
        return value0;
    }

    @Override
    public void setupAnim(float tickDelta) {
        this.tickDelta = tickDelta;
    }

    public boolean isLoopStarted() {
        return this.isLoopStarted;
    }

    public KeyframeAnimation getData() {
        return this.data;
    }

    public BodyPart getPart(String string) {
        BodyPart part = this.bodyParts.get(string);
        return part == null ? new BodyPart(null) : part;
    }

    public int getStopTick() {
        return this.data.stopTick;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public boolean isInfinite() {
        return this.data.isInfinite;
    }

    public class BodyPart {
        @Nullable
        public final KeyframeAnimation.StateCollection part;
        public final Axis x;
        public final Axis y;
        public final Axis z;
        public final RotationAxis pitch;
        public final RotationAxis yaw;
        public final RotationAxis roll;
        public final RotationAxis bendAxis;
        public final RotationAxis bend;

        public BodyPart(KeyframeAnimation.StateCollection part) {
            this.part = part;
            if (part != null) {
                this.x = new Axis(part.x);
                this.y = new Axis(part.y);
                this.z = new Axis(part.z);
                this.pitch = new RotationAxis(part.pitch);
                this.yaw = new RotationAxis(part.yaw);
                this.roll = new RotationAxis(part.roll);
                this.bendAxis = new RotationAxis(part.bendDirection);
                this.bend = new RotationAxis(part.bend);
            } else {
                this.x = null;
                this.y = null;
                this.z = null;
                this.pitch = null;
                this.yaw = null;
                this.roll = null;
                this.bendAxis = null;
                this.bend = null;
            }
        }

        public Pair<Float, Float> getBend(Pair<Float, Float> value0) {
            if (this.bend == null) {
                return value0;
            }
            return new Pair<Float, Float>(Float.valueOf(this.bendAxis.getValueAtCurrentTick(value0.getLeft().floatValue())), Float.valueOf(this.bend.getValueAtCurrentTick(value0.getRight().floatValue())));
        }

        public Vec3f getBodyOffset(Vec3f value0) {
            if (this.part == null) {
                return value0;
            }
            float x = this.x.getValueAtCurrentTick(((Float)value0.getX()).floatValue());
            float y = this.y.getValueAtCurrentTick(((Float)value0.getY()).floatValue());
            float z = this.z.getValueAtCurrentTick(((Float)value0.getZ()).floatValue());
            return new Vec3f(x, y, z);
        }

        public Vec3f getBodyRotation(Vec3f value0) {
            if (this.part == null) {
                return value0;
            }
            return new Vec3f(this.pitch.getValueAtCurrentTick(((Float)value0.getX()).floatValue()), this.yaw.getValueAtCurrentTick(((Float)value0.getY()).floatValue()), this.roll.getValueAtCurrentTick(((Float)value0.getZ()).floatValue()));
        }
    }

    public class RotationAxis
    extends Axis {
        public RotationAxis(KeyframeAnimation.StateCollection.State keyframes) {
            super(keyframes);
        }

        @Override
        public float getValueAtCurrentTick(float currentValue) {
            return MathHelper.clampToRadian(super.getValueAtCurrentTick(MathHelper.clampToRadian(currentValue)));
        }
    }

    public class Axis {
        protected final KeyframeAnimation.StateCollection.State keyframes;

        public Axis(KeyframeAnimation.StateCollection.State keyframes) {
            this.keyframes = keyframes;
        }

        private KeyframeAnimation.KeyFrame findBefore(int pos, float currentState) {
            if (pos == -1) {
                return KeyframeAnimationPlayer.this.currentTick < ((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.beginTick ? new KeyframeAnimation.KeyFrame(0, currentState) : (KeyframeAnimationPlayer.this.currentTick < ((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.endTick ? new KeyframeAnimation.KeyFrame(((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.beginTick, this.keyframes.defaultValue) : new KeyframeAnimation.KeyFrame(((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.endTick, this.keyframes.defaultValue));
            }
            KeyframeAnimation.KeyFrame frame = this.keyframes.getKeyFrames().get(pos);
            if (!KeyframeAnimationPlayer.this.isInfinite() && KeyframeAnimationPlayer.this.currentTick >= KeyframeAnimationPlayer.this.getData().endTick && pos == this.keyframes.length() - 1 && frame.tick < KeyframeAnimationPlayer.this.getData().endTick) {
                return new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.getData().endTick, frame.value, frame.ease);
            }
            return frame;
        }

        private KeyframeAnimation.KeyFrame findAfter(int pos, float currentState) {
            if (this.keyframes.length() > pos + 1) {
                return this.keyframes.getKeyFrames().get(pos + 1);
            }
            if (KeyframeAnimationPlayer.this.isInfinite()) {
                return new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.getData().endTick + 1, this.keyframes.defaultValue);
            }
            if (KeyframeAnimationPlayer.this.currentTick < KeyframeAnimationPlayer.this.getData().endTick && this.keyframes.length() > 0) {
                KeyframeAnimation.KeyFrame lastFrame = this.keyframes.getKeyFrames().get(this.keyframes.length() - 1);
                return new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.getData().endTick, lastFrame.value, lastFrame.ease);
            }
            return KeyframeAnimationPlayer.this.currentTick >= ((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.endTick ? new KeyframeAnimation.KeyFrame(((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.stopTick, currentState) : (KeyframeAnimationPlayer.this.currentTick >= KeyframeAnimationPlayer.this.getData().beginTick ? new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.getData().endTick, this.keyframes.defaultValue) : new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.getData().beginTick, this.keyframes.defaultValue));
        }

        public float getValueAtCurrentTick(float currentValue) {
            if (this.keyframes != null && this.keyframes.isEnabled()) {
                int pos = this.keyframes.findAtTick(KeyframeAnimationPlayer.this.currentTick);
                KeyframeAnimation.KeyFrame keyBefore = this.findBefore(pos, currentValue);
                if (KeyframeAnimationPlayer.this.isLoopStarted && keyBefore.tick < ((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.returnToTick) {
                    keyBefore = this.findBefore(this.keyframes.findAtTick(((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.endTick), currentValue);
                }
                KeyframeAnimation.KeyFrame keyAfter = this.findAfter(pos, currentValue);
                if (((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.isInfinite && keyAfter.tick > ((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.endTick) {
                    keyAfter = this.findAfter(this.keyframes.findAtTick(((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.returnToTick - 1), currentValue);
                }
                return this.getValueFromKeyframes(keyBefore, keyAfter);
            }
            return currentValue;
        }

        protected final float getValueFromKeyframes(KeyframeAnimation.KeyFrame before, KeyframeAnimation.KeyFrame after) {
            int tickBefore = before.tick;
            int tickAfter = after.tick;
            if (tickBefore >= tickAfter) {
                if (KeyframeAnimationPlayer.this.currentTick < tickBefore) {
                    tickBefore -= ((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.endTick - ((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.returnToTick + 1;
                } else {
                    tickAfter += ((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.endTick - ((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.returnToTick + 1;
                }
            }
            if (tickBefore == tickAfter) {
                return before.value;
            }
            float f = ((float)KeyframeAnimationPlayer.this.currentTick + KeyframeAnimationPlayer.this.tickDelta - (float)tickBefore) / (float)(tickAfter - tickBefore);
            return MathHelper.lerp(Easing.easingFromEnum(((KeyframeAnimationPlayer)KeyframeAnimationPlayer.this).data.isEasingBefore ? after.ease : before.ease, f), before.value, after.value);
        }
    }
}

