/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.kosmx.playerAnim.api.AnimUtils;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.IPlayerModel;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> entityModel, float f) {
        super(context, entityModel, f);
    }

    @Inject(method={"setupRotations(Lnet/minecraft/client/player/AbstractClientPlayer;Lcom/mojang/blaze3d/vertex/PoseStack;FFF)V"}, at={@At(value="RETURN")})
    private void applyBodyTransforms(AbstractClientPlayer abstractClientPlayerEntity, PoseStack matrixStack, float f, float bodyYaw, float tickDelta, CallbackInfo ci) {
        AnimationApplier animationPlayer = ((IAnimatedPlayer)abstractClientPlayerEntity).playerAnimator_getAnimation();
        animationPlayer.setTickDelta(tickDelta);
        if (animationPlayer.isActive()) {
            Vec3f vec3d = animationPlayer.get3DTransform("body", TransformType.POSITION, Vec3f.ZERO);
            matrixStack.m_85837_((double)((Float)vec3d.getX()).floatValue(), (double)((Float)vec3d.getY()).floatValue() + 0.7, (double)((Float)vec3d.getZ()).floatValue());
            Vec3f vec3f = animationPlayer.get3DTransform("body", TransformType.ROTATION, Vec3f.ZERO);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122270_(((Float)vec3f.getZ()).floatValue()));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122270_(((Float)vec3f.getY()).floatValue()));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122270_(((Float)vec3f.getX()).floatValue()));
            matrixStack.m_85837_(0.0, -0.7, 0.0);
        }
    }

    @Inject(method={"renderHand"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/PlayerModel;setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V")})
    private void notifyModelOfFirstPerson(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer abstractClientPlayer, ModelPart modelPart, ModelPart modelPart2, CallbackInfo ci) {
        EntityModel entityModel = this.m_7200_();
        if (entityModel instanceof IPlayerModel) {
            IPlayerModel playerModel = (IPlayerModel)entityModel;
            if (AnimUtils.disableFirstPersonAnim) {
                playerModel.playerAnimator_prepForFirstPersonRender();
            }
        }
    }
}

