/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.serialization;

import java.util.function.Function;
import java.util.function.Supplier;
import xaero.common.category.FilterObjectCategory;
import xaero.common.category.rule.ObjectCategoryHardRule;
import xaero.common.category.rule.ObjectCategoryRule;
import xaero.common.category.serialization.ObjectCategorySerializationHandler;
import xaero.common.category.serialization.data.FilterObjectCategoryData;
import xaero.common.category.serialization.data.ObjectCategoryDataSerializer;
import xaero.common.category.setting.ObjectCategorySetting;

public abstract class FilterObjectCategorySerializationHandler<E, P, S, D extends FilterObjectCategoryData<D>, C extends FilterObjectCategory<E, P, S, D, C>, B extends FilterObjectCategory.Builder<E, P, S, C, B>, DB extends FilterObjectCategoryData.Builder<D, DB>>
extends ObjectCategorySerializationHandler<D, C, B, DB> {
    private final Function<String, ObjectCategoryHardRule<E, P>> hardRuleGetter;

    protected FilterObjectCategorySerializationHandler(ObjectCategoryDataSerializer<D> serializer, Supplier<DB> dataBuilderFactory, Supplier<B> objectCategoryBuilderFactory, Function<String, ObjectCategorySetting<?>> settingTypeGetter, Function<String, ObjectCategoryHardRule<E, P>> hardRuleGetter) {
        super(serializer, dataBuilderFactory, objectCategoryBuilderFactory, settingTypeGetter);
        this.hardRuleGetter = hardRuleGetter;
    }

    @Override
    protected DB getConfiguredDataBuilderForCategory(C category) {
        FilterObjectCategoryData.Builder dataBuilder = (FilterObjectCategoryData.Builder)super.getConfiguredDataBuilderForCategory(category);
        ObjectCategoryRule baseRule = ((FilterObjectCategory)category).getBaseRule();
        dataBuilder.setHardInclude(baseRule == null ? "nothing" : baseRule.getName());
        dataBuilder.setExcludeMode(((FilterObjectCategory)category).getExcludeMode());
        ((FilterObjectCategory)category).getIncludeList().forEach(el -> dataBuilder.addToIncludeList((String)el));
        ((FilterObjectCategory)category).getExcludeList().forEach(el -> dataBuilder.addToExcludeList((String)el));
        dataBuilder.setIncludeListInSuperCategory(((FilterObjectCategory)category).getIncludeList().getIncludeInSuperCategory());
        return (DB)dataBuilder;
    }

    @Override
    protected B getConfiguredCategoryBuilderForData(D data) {
        ObjectCategoryHardRule<E, P> serializedHardRule;
        FilterObjectCategory.Builder objectCategoryBuilder = (FilterObjectCategory.Builder)super.getConfiguredCategoryBuilderForData(data);
        String hardInclude = ((FilterObjectCategoryData)data).getHardInclude();
        ObjectCategoryHardRule<E, P> objectCategoryHardRule = serializedHardRule = this.hardRuleGetter == null ? null : this.hardRuleGetter.apply(hardInclude);
        if (serializedHardRule != null) {
            objectCategoryBuilder.setBaseRule(serializedHardRule);
        }
        objectCategoryBuilder.getExcludeListBuilder().setExcludeMode(((FilterObjectCategoryData)data).getExcludeMode());
        ((FilterObjectCategoryData)data).getExcludeListIterator().forEachRemaining(s -> objectCategoryBuilder.getExcludeListBuilder().getList().add((String)s));
        ((FilterObjectCategoryData)data).getIncludeListIterator().forEachRemaining(s -> objectCategoryBuilder.getIncludeListBuilder().getList().add((String)s));
        objectCategoryBuilder.getIncludeListBuilder().setIncludeInSuperCategory(((FilterObjectCategoryData)data).getIncludeListInSuperCategory());
        return (B)objectCategoryBuilder;
    }

    public static abstract class Builder<E, P, S, D extends FilterObjectCategoryData<D>, C extends FilterObjectCategory<E, P, S, D, C>, B extends FilterObjectCategory.Builder<E, P, S, C, B>, DB extends FilterObjectCategoryData.Builder<D, DB>, SH extends FilterObjectCategorySerializationHandler<E, P, S, D, C, B, DB>, SHB extends Builder<E, P, S, D, C, B, DB, SH, SHB>>
    extends ObjectCategorySerializationHandler.Builder<D, C, B, DB, SH, SHB> {
        protected Function<String, ObjectCategoryHardRule<E, P>> hardRuleGetter;

        public Builder(ObjectCategoryDataSerializer.Builder<D> serializerBuilder) {
            super(serializerBuilder);
        }

        @Override
        public SHB setDefault() {
            super.setDefault();
            this.setHardRuleGetter(null);
            return (SHB)((Builder)this.self);
        }

        @Override
        public SH build() {
            if (this.hardRuleGetter == null) {
                throw new IllegalStateException("required fields not set!");
            }
            return (SH)((FilterObjectCategorySerializationHandler)super.build());
        }

        public SHB setHardRuleGetter(Function<String, ObjectCategoryHardRule<E, P>> hardRuleGetter) {
            this.hardRuleGetter = hardRuleGetter;
            return (SHB)((Builder)this.self);
        }
    }
}

