/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.message.basic.HandshakePacket;
import xaero.common.message.tracker.ClientboundPlayerTrackerResetPacket;
import xaero.common.server.MinecraftServerData;
import xaero.common.server.MineraftServerDataInitializer;
import xaero.common.server.level.LevelMapProperties;
import xaero.common.server.level.LevelMapPropertiesIO;
import xaero.common.server.player.IServerPlayer;
import xaero.common.server.player.ServerPlayerData;

public class ForgeCommonEventHandler {
    private final IXaeroMinimap modMain;

    public ForgeCommonEventHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public void register() {
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        if (oldPlayer instanceof ServerPlayer) {
            Player newPlayer = event.getEntity();
            ((IServerPlayer)newPlayer).setXaeroMinimapPlayerData(ServerPlayerData.get((ServerPlayer)oldPlayer));
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        new MineraftServerDataInitializer().init(event.getServer(), this.modMain);
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            this.modMain.getMessageHandler().sendToPlayer((ServerPlayer)player, new ClientboundPlayerTrackerResetPacket());
        }
    }

    public void onPlayerWorldJoin(ServerPlayer player) {
        this.modMain.getMessageHandler().sendToPlayer(player, new HandshakePacket());
        Path propertiesPath = player.f_19853_.m_7654_().m_129843_(LevelMapPropertiesIO.FILE_NAME);
        try {
            MinecraftServerData serverData = MinecraftServerData.get(player.m_20194_());
            LevelMapProperties properties = serverData.getLevelProperties(propertiesPath);
            this.modMain.getMessageHandler().sendToPlayer(player, properties);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("suppressed exception", t);
            player.f_8906_.m_9942_((Component)Component.m_237115_((String)"gui.xaero_error_loading_properties"));
        }
    }
}

