/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.IHasTranslationKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class MekanismDamageSource
extends DamageSource
implements IHasTranslationKey {
    private static final List<MekanismDamageSource> INTERNAL_DAMAGE_SOURCES = new ArrayList<MekanismDamageSource>();
    public static final List<MekanismDamageSource> DAMAGE_SOURCES = Collections.unmodifiableList(INTERNAL_DAMAGE_SOURCES);
    public static final MekanismDamageSource LASER = new MekanismDamageSource("laser");
    public static final MekanismDamageSource RADIATION = new MekanismDamageSource("radiation").bypassArmor();
    private final String translationKey = "death.attack." + this.m_19385_();
    @Nullable
    private final Vec3 damageLocation;

    private MekanismDamageSource(String damageType) {
        this(damageType, null);
        INTERNAL_DAMAGE_SOURCES.add(this);
    }

    private MekanismDamageSource(@NotNull String damageType, @Nullable Vec3 damageLocation) {
        super("mekanism." + damageType);
        this.damageLocation = damageLocation;
    }

    public MekanismDamageSource fromPosition(@NotNull Vec3 damageLocation) {
        return new MekanismDamageSource(this.m_19385_(), damageLocation);
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Nullable
    public Vec3 m_7270_() {
        return this.damageLocation;
    }

    public MekanismDamageSource setProjectile() {
        super.m_19366_();
        return this;
    }

    public MekanismDamageSource setExplosion() {
        super.m_19375_();
        return this;
    }

    public MekanismDamageSource bypassArmor() {
        super.m_19380_();
        return this;
    }

    public MekanismDamageSource bypassInvul() {
        super.m_19381_();
        return this;
    }

    public MekanismDamageSource bypassMagic() {
        super.m_19382_();
        return this;
    }

    public MekanismDamageSource setIsFire() {
        super.m_19383_();
        return this;
    }

    public MekanismDamageSource setScalesWithDifficulty() {
        super.m_19386_();
        return this;
    }

    public MekanismDamageSource setMagic() {
        super.m_19389_();
        return this;
    }
}

