/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import java.util.Collections;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.ProxiedEnergyContainerHolder;
import mekanism.common.content.matrix.MatrixMultiblockData;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.multiblock.IMultiblockEjector;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.multiblock.TileEntityInductionCasing;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityInductionPort
extends TileEntityInductionCasing
implements IMultiblockEjector {
    private Set<Direction> outputDirections = Collections.emptySet();

    public TileEntityInductionPort(BlockPos pos, BlockState state) {
        super(MekanismBlocks.INDUCTION_PORT, pos, state);
        this.delaySupplier = () -> 0;
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        return ProxiedEnergyContainerHolder.create(side -> !this.getActive(), side -> this.getActive(), side -> ((MatrixMultiblockData)this.getMultiblock()).getEnergyContainers((Direction)side));
    }

    @Override
    protected boolean onUpdateServer(MatrixMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer(multiblock);
        if (multiblock.isFormed() && this.getActive()) {
            CableUtils.emit(this.outputDirections, multiblock.getEnergyContainer(), (BlockEntity)this);
        }
        return needsPacket;
    }

    @Override
    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.ENERGY) {
            return false;
        }
        return super.persists(type);
    }

    @Override
    public void setEjectSides(Set<Direction> sides) {
        this.outputDirections = sides;
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            boolean oldMode = this.getActive();
            this.setActive(!oldMode);
            player.m_213846_(MekanismUtils.logFormat(MekanismLang.INDUCTION_PORT_MODE.translate(BooleanStateDisplay.InputOutput.of(oldMode, true))));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public int getRedstoneLevel() {
        return ((MatrixMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    @ComputerMethod
    private boolean getMode() {
        return this.getActive();
    }

    @ComputerMethod
    private void setMode(boolean output) {
        this.setActive(output);
    }
}

