/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.datagen.api.datagen;

import com.mojang.datafixers.util.Either;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import novamachina.exnihilosequentia.common.block.BaseBlock;
import novamachina.exnihilosequentia.common.block.BlockSieve;
import novamachina.exnihilosequentia.common.blockentity.crucible.CrucibleTypeEnum;
import novamachina.exnihilosequentia.common.crafting.compost.CompostRecipeBuilder;
import novamachina.exnihilosequentia.common.crafting.crook.CrookRecipeBuilder;
import novamachina.exnihilosequentia.common.crafting.crucible.CrucibleRecipeBuilder;
import novamachina.exnihilosequentia.common.crafting.fluiditem.FluidItemRecipeBuilder;
import novamachina.exnihilosequentia.common.crafting.fluidontop.FluidOnTopRecipeBuilder;
import novamachina.exnihilosequentia.common.crafting.fluidtransform.FluidTransformRecipeBuilder;
import novamachina.exnihilosequentia.common.crafting.hammer.HammerRecipeBuilder;
import novamachina.exnihilosequentia.common.crafting.heat.HeatRecipeBuilder;
import novamachina.exnihilosequentia.common.crafting.sieve.MeshWithChance;
import novamachina.exnihilosequentia.common.crafting.sieve.SieveRecipeBuilder;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.item.MeshItem;
import novamachina.exnihilosequentia.common.item.OreItem;
import novamachina.exnihilosequentia.common.item.ore.Ore;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRecipeGenerator
extends RecipeProvider {
    @Nonnull
    public static final String PEBBLE_CONDITION = "has_pebble";
    @Nonnull
    protected static final String CHUNK_CONDITION = "has_chunk";
    @Nonnull
    private static final String MATERIAL_CONDITION = "has_material";
    @Nonnull
    private final String modId;

    protected AbstractRecipeGenerator(@Nonnull DataGenerator generator, @Nonnull String modId) {
        super(generator);
        this.modId = modId;
    }

    public static void createMCCompost(@Nonnull ItemLike item, float chance) {
        ComposterBlock.f_51914_.put((Object)item, chance);
    }

    @Nonnull
    public String m_6055_() {
        return "Recipes: " + this.modId;
    }

    @Nonnull
    protected ResourceLocation compostLoc(@Nonnull String id) {
        return new ResourceLocation(this.modId, "compost/" + this.prependRecipePrefix(id));
    }

    @Nonnull
    protected ResourceLocation crookLoc(@Nonnull String id) {
        return new ResourceLocation(this.modId, "crook/" + this.prependRecipePrefix(id));
    }

    @Nonnull
    protected ResourceLocation crucibleLoc(@Nonnull String id) {
        return new ResourceLocation(this.modId, "crucible/" + this.prependRecipePrefix(id));
    }

    @Nonnull
    protected ResourceLocation fluidItemLoc(@Nonnull String id) {
        return new ResourceLocation(this.modId, "fluid_item/" + this.prependRecipePrefix(id));
    }

    @Nonnull
    protected ResourceLocation fluidOnTopLoc(@Nonnull String id) {
        return new ResourceLocation(this.modId, "fluid_on_top/" + this.prependRecipePrefix(id));
    }

    @Nonnull
    protected ResourceLocation fluidTransformLoc(@Nonnull String id) {
        return new ResourceLocation(this.modId, "fluid_transform/" + this.prependRecipePrefix(id));
    }

    @Nonnull
    protected ResourceLocation hammerLoc(@Nonnull String id) {
        return new ResourceLocation(this.modId, "hammer/" + this.prependRecipePrefix(id));
    }

    @Nonnull
    protected ResourceLocation heatLoc(@Nonnull String id) {
        return new ResourceLocation(this.modId, "heat/" + this.prependRecipePrefix(id));
    }

    @Nonnull
    protected ResourceLocation sieveLoc(@Nonnull String id) {
        return new ResourceLocation(this.modId, "sieve/" + this.prependRecipePrefix(id));
    }

    protected void createOreRecipes(Ore ore, ResourceLocation registryId, Consumer<FinishedRecipe> consumer) {
        this.createOre(ore, consumer);
        if (ore.getRawOreItem().left().isPresent() && ore.getIngotItem().left().isPresent()) {
            this.createSmeltingRecipe(consumer, (Item)((RegistryObject)ore.getRawOreItem().left().get()).get(), (Item)((RegistryObject)ore.getIngotItem().left().get()).get(), 0.7f, 200, 0.7f, 100, CHUNK_CONDITION, registryId);
        }
    }

    protected void createOre(@Nonnull Ore ore, @Nonnull Consumer<FinishedRecipe> consumer) {
        this.createRawRecipe(ore, consumer);
        this.createNuggetRecipes(ore, consumer);
    }

    private void createNuggetRecipes(Ore ore, Consumer<FinishedRecipe> consumer) {
        if (ore.getNuggetItem().left().isPresent()) {
            Either<RegistryObject<OreItem>, Item> eitherIngot = ore.getIngotItem();
            Item ingot = eitherIngot.left().isPresent() ? (Item)((RegistryObject)eitherIngot.left().get()).get() : (Item)eitherIngot.right().get();
            Item nugget = (Item)((RegistryObject)ore.getNuggetItem().left().get()).get();
            ShapedRecipeBuilder.m_126116_((ItemLike)ingot).m_126130_("xxx").m_126130_("xxx").m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)nugget).m_126145_(this.modId).m_126132_("has_nugget", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{nugget})).m_126140_(consumer, new ResourceLocation(this.modId, this.prependRecipePrefix(ForgeRegistries.ITEMS.getKey((Object)ingot).m_135815_() + "_from_nugget")));
            ShapelessRecipeBuilder.m_126191_((ItemLike)nugget, (int)9).m_126209_((ItemLike)ingot).m_126132_("has_ingot", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ingot})).m_126140_(consumer, this.createSaveLocation(ForgeRegistries.ITEMS.getKey((Object)nugget)));
        }
    }

    private void createRawRecipe(@NotNull Ore ore, @NotNull Consumer<FinishedRecipe> consumer) {
        OreItem piece = ore.getPieceItem();
        Either<RegistryObject<OreItem>, Item> rawEither = ore.getRawOreItem();
        Item rawOre = rawEither.left().isPresent() ? (Item)((RegistryObject)rawEither.left().get()).get() : (Item)rawEither.right().get();
        ShapedRecipeBuilder.m_126116_((ItemLike)rawOre).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)piece).m_126145_(this.modId).m_126132_("has_piece", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{piece})).m_126140_(consumer, new ResourceLocation(this.modId, this.prependRecipePrefix(ForgeRegistries.ITEMS.getKey((Object)rawOre).m_135815_())));
    }

    protected void createSmelting(@Nonnull Ore ore, @Nonnull Consumer<FinishedRecipe> consumer) {
        Either<RegistryObject<OreItem>, Item> rawEither = ore.getRawOreItem();
        Item raw = rawEither.left().isPresent() ? (Item)((RegistryObject)rawEither.left().get()).get() : (Item)rawEither.right().get();
        Either<RegistryObject<OreItem>, Item> ingotEither = ore.getIngotItem();
        Item ingot = ingotEither.left().isPresent() ? (Item)((RegistryObject)ingotEither.left().get()).get() : (Item)ingotEither.right().get();
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{raw}), (ItemLike)ingot, (float)0.7f, (int)200).m_126132_(CHUNK_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{raw})).m_126140_(consumer, new ResourceLocation(this.modId, this.prependRecipePrefix(ore.getIngotName())));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{raw}), (ItemLike)ingot, (float)0.7f, (int)100).m_126132_(CHUNK_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{raw})).m_126140_(consumer, new ResourceLocation(this.modId, this.prependRecipePrefix("blast_" + ore.getIngotName())));
    }

    protected String prependRecipePrefix(@Nonnull String id) {
        return "ens_" + id;
    }

    protected ResourceLocation createSaveLocation(@Nonnull ResourceLocation location) {
        return new ResourceLocation(location.m_135827_(), this.prependRecipePrefix(location.m_135815_()));
    }

    protected void createCompostRecipe(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Item item, int amount, @Nonnull String string) {
        CompostRecipeBuilder.builder().input((ItemLike)item).amount(amount).build(consumer, this.compostLoc(string));
    }

    protected void createCompostRecipe(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Block block, int amount, @Nonnull String string) {
        CompostRecipeBuilder.builder().input((ItemLike)block).amount(amount).build(consumer, this.compostLoc(string));
    }

    protected void createCompostRecipe(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull TagKey<Item> item, int amount, @Nonnull String string) {
        CompostRecipeBuilder.builder().input(item).amount(amount).build(consumer, this.compostLoc(string));
    }

    protected void createCrookRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull TagKey<Item> itemInput, @Nonnull ItemLike itemDrop, float chance, @Nonnull String id) {
        CrookRecipeBuilder.builder().input(itemInput).addDrop(itemDrop, chance).build(consumer, this.crookLoc(id));
    }

    protected void createCrookRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Block itemInput, @Nonnull ItemLike itemDrop, float chance, @Nonnull String id) {
        CrookRecipeBuilder.builder().input(itemInput).addDrop(itemDrop, chance).build(consumer, this.crookLoc(id));
    }

    protected void createFiredCrucibleRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Block block, int amount, @Nonnull String id) {
        CrucibleRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{block})).amount(amount).fluidResult((Fluid)Fluids.f_76195_).crucibleType(CrucibleTypeEnum.FIRED).build(consumer, this.crucibleLoc(id));
    }

    protected void createFiredCrucibleRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull TagKey<Item> item, int amount, @Nonnull String id) {
        CrucibleRecipeBuilder.builder().input(Ingredient.m_204132_(item)).amount(amount).fluidResult((Fluid)Fluids.f_76195_).crucibleType(CrucibleTypeEnum.FIRED).build(consumer, this.crucibleLoc(id));
    }

    protected void createWaterCrucibleRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull TagKey<Item> item, int amount, @Nonnull String id) {
        CrucibleRecipeBuilder.builder().input(Ingredient.m_204132_(item)).amount(amount).fluidResult((Fluid)Fluids.f_76193_).crucibleType(CrucibleTypeEnum.WOOD).build(consumer, this.crucibleLoc(id));
    }

    protected void createWaterCrucibleRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Item item, int amount, @Nonnull String id) {
        CrucibleRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item})).amount(amount).fluidResult((Fluid)Fluids.f_76193_).crucibleType(CrucibleTypeEnum.WOOD).build(consumer, this.crucibleLoc(id));
    }

    protected void createFluidItemRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Fluid fluidInput, @Nonnull Item itemInput, @Nonnull Block blockOutput, @Nonnull String id) {
        FluidItemRecipeBuilder.builder().fluidInBarrel(fluidInput).input((ItemLike)itemInput).result((ItemLike)blockOutput).build(consumer, this.fluidItemLoc(id));
    }

    protected void createFluidItemRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Fluid fluidInput, @Nonnull TagKey<Item> itemInput, @Nonnull Block blockOutput, @Nonnull String id) {
        FluidItemRecipeBuilder.builder().fluidInBarrel(fluidInput).input(itemInput).result((ItemLike)blockOutput).build(consumer, this.fluidItemLoc(id));
    }

    protected void createFluidOnTopRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Fluid fluidInTank, @Nonnull Fluid fluidOnTop, @Nonnull Block blockOutput, @Nonnull String id) {
        FluidOnTopRecipeBuilder.builder().fluidInTank(fluidInTank).fluidOnTop(fluidOnTop).result((ItemLike)blockOutput).build(consumer, this.fluidOnTopLoc(id));
    }

    protected void createFluidTransformRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Fluid fluidInTank, @Nonnull TagKey<Item> catalyst, @Nonnull Fluid fluidResult, @Nonnull String id) {
        FluidTransformRecipeBuilder.builder().fluidInTank(fluidInTank).catalyst(Ingredient.m_204132_(catalyst)).result(fluidResult).build(consumer, this.fluidTransformLoc(id));
    }

    protected void createFluidTransformRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Fluid fluidInTank, @Nonnull Item catalyst, @Nonnull Fluid fluidResult, @Nonnull String id) {
        FluidTransformRecipeBuilder.builder().fluidInTank(fluidInTank).catalyst(Ingredient.m_43929_((ItemLike[])new ItemLike[]{catalyst})).result(fluidResult).build(consumer, this.fluidTransformLoc(id));
    }

    protected void createHammerRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Block blockInput, @Nonnull Block blockOutput, @Nonnull String id) {
        HammerRecipeBuilder.builder().input((ItemLike)blockInput).addDrop((ItemLike)blockOutput).build(consumer, this.hammerLoc(id));
    }

    protected void createHeatRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Block block, int amount, @Nonnull String id) {
        HeatRecipeBuilder.builder().input(block).amount(amount).build(consumer, this.heatLoc(id));
    }

    protected void createHeatRecipes(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Block block, int amount, @Nonnull StatePropertiesPredicate properties, @Nonnull String id) {
        HeatRecipeBuilder.builder().input(block).amount(amount).properties(properties).build(consumer, this.heatLoc(id));
    }

    protected void createSmeltingRecipe(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Item input, @Nonnull Item output, float xpSmelt, int durationSmelt, float xpBlast, int durationBlast, @Nonnull String condition, @Nonnull ResourceLocation rl) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (ItemLike)output, (float)xpSmelt, (int)durationSmelt).m_126132_(condition, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, this.createSaveLocation(rl));
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (ItemLike)output, (float)xpBlast, (int)durationBlast).m_126132_(condition, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, this.createSaveLocation(new ResourceLocation(rl + "_blast")));
    }

    protected void createCookingRecipe(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Item input, @Nonnull Item output, float xpCampfire, int durationCampfire, float xpSmoker, int durationSmoker, @Nonnull String condition, @Nonnull ResourceLocation rl) {
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (ItemLike)output, (float)xpCampfire, (int)durationCampfire, (SimpleCookingSerializer)RecipeSerializer.f_44094_).m_126132_(condition, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, this.createSaveLocation(new ResourceLocation(rl + "_from_campfire")));
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (ItemLike)output, (float)xpSmoker, (int)durationSmoker, (SimpleCookingSerializer)RecipeSerializer.f_44093_).m_126132_(condition, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, this.createSaveLocation(new ResourceLocation(rl + "_from_smoker")));
    }

    protected void createBarrel(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull RegistryObject<BaseBlock> barrel, @Nonnull TagKey<Item> block, @Nonnull Item slab) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)barrel.get())).m_126130_("x x").m_126130_("x x").m_126130_("x-x").m_206416_(Character.valueOf('x'), block).m_126127_(Character.valueOf('-'), (ItemLike)slab).m_126145_("exnihilosequentia").m_126132_("has_walls", (CriterionTriggerInstance)AbstractRecipeGenerator.m_206406_(block)).m_126132_("has_base", (CriterionTriggerInstance)AbstractRecipeGenerator.m_125977_((ItemLike)slab)).m_126140_(consumer, this.createSaveLocation(barrel.getId()));
    }

    protected void createBarrel(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull RegistryObject<BaseBlock> barrel, @Nonnull Item block, @Nonnull Item slab) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)barrel.get())).m_126130_("x x").m_126130_("x x").m_126130_("x-x").m_126127_(Character.valueOf('x'), (ItemLike)block).m_126127_(Character.valueOf('-'), (ItemLike)slab).m_126145_("exnihilosequentia").m_126132_("has_walls", (CriterionTriggerInstance)AbstractRecipeGenerator.m_125977_((ItemLike)block)).m_126132_("has_base", (CriterionTriggerInstance)AbstractRecipeGenerator.m_125977_((ItemLike)slab)).m_126140_(consumer, this.createSaveLocation(barrel.getId()));
    }

    protected void createCrucible(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull RegistryObject<BaseBlock> crucible, @Nonnull Item block, @Nonnull Item slab) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)crucible.get())).m_126130_("c c").m_126130_("clc").m_126130_("s s").m_126127_(Character.valueOf('c'), (ItemLike)block).m_126127_(Character.valueOf('l'), (ItemLike)slab).m_206416_(Character.valueOf('s'), Tags.Items.RODS_WOODEN).m_126145_("exnihilosequentia").m_126132_("has_logs", (CriterionTriggerInstance)AbstractRecipeGenerator.m_125977_((ItemLike)block)).m_126140_(consumer, this.createSaveLocation(crucible.getId()));
    }

    protected void createCrucible(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull RegistryObject<BaseBlock> crucible, @Nonnull TagKey<Item> block, @Nonnull TagKey<Item> slab) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)crucible.get())).m_126130_("c c").m_126130_("clc").m_126130_("s s").m_206416_(Character.valueOf('c'), block).m_206416_(Character.valueOf('l'), slab).m_206416_(Character.valueOf('s'), Tags.Items.RODS_WOODEN).m_126145_("exnihilosequentia").m_126132_("has_logs", (CriterionTriggerInstance)AbstractRecipeGenerator.m_206406_(block)).m_126140_(consumer, this.createSaveLocation(crucible.getId()));
    }

    protected void createSieve(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull RegistryObject<?> sieve, @Nonnull Item block, @Nonnull Item slab) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((BlockSieve)sieve.get())).m_126130_("p p").m_126130_("plp").m_126130_("s s").m_126127_(Character.valueOf('p'), (ItemLike)block).m_126127_(Character.valueOf('l'), (ItemLike)slab).m_206416_(Character.valueOf('s'), Tags.Items.RODS_WOODEN).m_126132_("has_plank", (CriterionTriggerInstance)AbstractRecipeGenerator.m_125977_((ItemLike)block)).m_126140_(consumer, this.createSaveLocation(sieve.getId()));
    }

    protected void createCrook(@Nonnull Item result, @Nonnull Item input, @Nonnull Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_126130_("xx").m_126130_(" x").m_126130_(" x").m_126127_(Character.valueOf('x'), (ItemLike)input).m_126145_("exnihilosequentia").m_126132_(PEBBLE_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, this.createSaveLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)result))));
    }

    protected void createCrook(@Nonnull Item result, @Nonnull TagKey<Item> input, @Nonnull Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_126130_("xx").m_126130_(" x").m_126130_(" x").m_206416_(Character.valueOf('x'), input).m_126145_("exnihilosequentia").m_126132_(PEBBLE_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(input).m_45077_()})).m_126140_(consumer, this.createSaveLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)result))));
    }

    protected void createHammer(@Nonnull Item output, @Nonnull TagKey<Item> input, @Nonnull Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126130_(" x ").m_126130_(" -x").m_126130_("-  ").m_206416_(Character.valueOf('x'), input).m_206416_(Character.valueOf('-'), Tags.Items.RODS).m_126132_("has_stick", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.RODS).m_45077_()})).m_126132_(MATERIAL_CONDITION, (CriterionTriggerInstance)AbstractRecipeGenerator.m_206406_(input)).m_126140_(consumer, this.createSaveLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output))));
    }

    protected void createHammer(@Nonnull Item output, @Nonnull Item input, @Nonnull Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126130_(" x ").m_126130_(" -x").m_126130_("-  ").m_126127_(Character.valueOf('x'), (ItemLike)input).m_206416_(Character.valueOf('-'), Tags.Items.RODS).m_126132_("has_stick", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.RODS).m_45077_()})).m_126132_(MATERIAL_CONDITION, (CriterionTriggerInstance)AbstractRecipeGenerator.m_125977_((ItemLike)input)).m_126140_(consumer, this.createSaveLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output))));
    }

    protected void createPebbleBlock(@Nonnull Block result, @Nonnull Item input, @Nonnull Consumer<FinishedRecipe> consumer) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)result);
        if (resourceLocation == null) {
            return;
        }
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)input).m_126145_("exnihilosequentia").m_126132_(PEBBLE_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, this.createSaveLocation(resourceLocation));
    }

    protected void createMesh(@Nonnull Item output, @Nonnull Item inputMesh, @Nonnull TagKey<Item> inputItem, @Nonnull Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126130_("i i").m_126130_("imi").m_126130_("i i").m_206416_(Character.valueOf('i'), inputItem).m_126127_(Character.valueOf('m'), (ItemLike)inputMesh).m_126132_("has_mesh", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{inputMesh})).m_126140_(consumer, this.createSaveLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output))));
    }

    protected void createMesh(@Nonnull Item output, @Nonnull Item inputMesh, @Nonnull Item inputItem, @Nonnull Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)output).m_126130_("i i").m_126130_("imi").m_126130_("i i").m_126127_(Character.valueOf('i'), (ItemLike)inputItem).m_126127_(Character.valueOf('m'), (ItemLike)inputMesh).m_126132_("has_mesh", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{inputMesh})).m_126140_(consumer, this.createSaveLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output))));
    }

    protected void createSeeds(ItemLike seed, @Nonnull Consumer<FinishedRecipe> consumer) {
        this.createSeeds(seed, consumer, Blocks.f_50493_);
    }

    protected void createSeeds(ItemLike seed, @Nonnull Consumer<FinishedRecipe> consumer, Block inputBlock) {
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)seed.m_5456_());
        if (resourceLocation == null) {
            return;
        }
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{inputBlock})).addResult(seed)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.05f)).build(consumer, this.sieveLoc(resourceLocation.m_135815_()));
    }

    protected void createWaterSeeds(ItemLike seed, Consumer<FinishedRecipe> consumer) {
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)seed.m_5456_());
        if (resourceLocation == null) {
            return;
        }
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_204132_((TagKey)ItemTags.f_13137_)).addResult(seed)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.05f)).isWaterlogged().build(consumer, this.sieveLoc(resourceLocation.m_135815_()));
    }
}

