/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.forge.network;

import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.GeyserEmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.forge.mixin.ChunkMapAccessor;
import io.github.kosmx.emotes.forge.mixin.TrackedEntityAccessor;
import io.github.kosmx.emotes.server.network.AbstractServerEmotePlay;
import io.github.kosmx.emotes.server.network.IServerNetworkInstance;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.event.EventNetworkChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ServerNetwork
extends AbstractServerEmotePlay<Player> {
    public static final ResourceLocation channelID = new ResourceLocation("emotecraft", "emote");
    public static final ResourceLocation geyserChannelID = new ResourceLocation("geyser", "emote");
    public static final EventNetworkChannel channel = NetworkRegistry.newEventChannel((ResourceLocation)channelID, () -> "8", s -> true, s -> true);
    public static final EventNetworkChannel geyserChannel = NetworkRegistry.newEventChannel((ResourceLocation)geyserChannelID, () -> "0", s -> true, s -> true);
    public static ServerNetwork instance = new ServerNetwork();

    public void init() {
        channel.addListener(this::receiveByteBuf);
        geyserChannel.addListener(this::receiveGeyserEvent);
    }

    public void receiveByteBuf(NetworkEvent.ClientCustomPayloadEvent event) {
        instance.receiveMessage(((NetworkEvent.Context)event.getSource().get()).getSender(), ((NetworkEvent.Context)event.getSource().get()).getSender().f_8906_, event.getPayload());
        ((NetworkEvent.Context)event.getSource().get()).setPacketHandled(true);
    }

    public void receiveGeyserEvent(NetworkEvent.ClientCustomPayloadEvent networkEvent) {
        this.receiveGeyserMessage(((NetworkEvent.Context)networkEvent.getSource().get()).getSender(), this.toBytes(networkEvent.getPayload()));
        ((NetworkEvent.Context)networkEvent.getSource().get()).setPacketHandled(true);
    }

    void receiveMessage(ServerPlayer player, ServerGamePacketListenerImpl handler, FriendlyByteBuf buf) {
        try {
            this.receiveMessage(this.toBytes(buf), player, (INetworkInstance)handler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    byte[] toBytes(FriendlyByteBuf buf) {
        if (buf.isDirect()) {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.getBytes(buf.readerIndex(), bytes);
            return bytes;
        }
        return buf.array();
    }

    @Override
    protected UUID getUUIDFromPlayer(Player player) {
        return player.m_20148_();
    }

    @Override
    protected Player getPlayerFromUUID(UUID player) {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(player);
    }

    @Override
    protected long getRuntimePlayerID(Player player) {
        return player.m_19879_();
    }

    @Override
    protected IServerNetworkInstance getPlayerNetworkInstance(Player player) {
        return (IServerNetworkInstance)((ServerPlayer)player).f_8906_;
    }

    @Override
    protected void sendForEveryoneElse(GeyserEmotePacket packet, Player player) {
        try {
            ServerNetwork.sendConsumer(player, serverPlayer -> {
                try {
                    if (geyserChannel.isRemotePresent(serverPlayer.f_8906_.m_6198_())) {
                        PacketDistributor.PLAYER.with(() -> serverPlayer).send(ServerNetwork.newS2CEmotesPacket(geyserChannelID, packet.write()));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void sendForEveryoneElse(NetData data, @Nullable GeyserEmotePacket emotePacket, Player player) {
        data.player = player.m_20148_();
        try {
            ServerNetwork.sendConsumer(player, serverPlayer -> {
                try {
                    if (channel.isRemotePresent(serverPlayer.f_8906_.m_6198_())) {
                        PacketDistributor.PLAYER.with(() -> serverPlayer).send(ServerNetwork.newS2CEmotesPacket(data, serverPlayer));
                    } else if (emotePacket != null && geyserChannel.isRemotePresent(serverPlayer.f_8906_.m_6198_())) {
                        PacketDistributor.PLAYER.with(() -> serverPlayer).send(ServerNetwork.newS2CEmotesPacket(geyserChannelID, emotePacket.write()));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Packet newS2CEmotesPacket(NetData data, ServerPlayer player) throws IOException {
        EmotePacket.Builder packetBuilder = new EmotePacket.Builder(data);
        packetBuilder.setVersion(((IServerNetworkInstance)player.f_8906_).getRemoteVersions());
        return new ClientboundCustomPayloadPacket(channelID, new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])packetBuilder.build().write().array())));
    }

    public static Packet newS2CEmotesPacket(ResourceLocation channelID, byte[] data) throws IOException {
        return new ClientboundCustomPayloadPacket(channelID, new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data)));
    }

    @Override
    protected void sendForPlayerInRange(NetData data, Player player, UUID target) {
        Player destination = player.m_20193_().m_46003_(target);
        if (destination != null) {
            ServerNetwork.sendConsumer(player, serverPlayer -> {
                if (serverPlayer == destination) {
                    this.sendForPlayer(data, player, target);
                }
            });
        }
    }

    @Override
    protected void sendForPlayer(NetData data, Player player, UUID target) {
        try {
            PacketDistributor.PLAYER.with(() -> (ServerPlayer)player.m_20193_().m_46003_(target)).send(ServerNetwork.newS2CEmotesPacket(data, (ServerPlayer)player));
        }
        catch (IOException | RuntimeException e) {
            e.printStackTrace();
        }
    }

    public static void sendConsumer(Player player, Consumer<ServerPlayer> consumer) {
        TrackedEntityAccessor tracker = (TrackedEntityAccessor)((ChunkMapAccessor)((ServerChunkCache)player.m_20193_().m_7726_()).f_8325_).getTrackedEntity().get(player.m_19879_());
        if (tracker != null) {
            tracker.getPlayersTracking().forEach(serverPlayerConnection -> consumer.accept(serverPlayerConnection.m_142253_()));
        }
    }
}

