/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour.filtering;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FilteringBehaviour
extends BlockEntityBehaviour
implements ValueSettingsBehaviour {
    public static final BehaviourType<FilteringBehaviour> TYPE = new BehaviourType();
    public MutableComponent customLabel;
    ValueBoxTransform slotPositioning;
    boolean showCount;
    private ItemStack filter = ItemStack.f_41583_;
    public int count;
    public boolean upTo;
    private Predicate<ItemStack> predicate;
    private Consumer<ItemStack> callback;
    private Supplier<Boolean> isActive;
    private Supplier<Boolean> showCountPredicate;
    boolean recipeFilter;
    boolean fluidFilter;

    public FilteringBehaviour(SmartBlockEntity be, ValueBoxTransform slot) {
        super(be);
        this.slotPositioning = slot;
        this.showCount = false;
        this.callback = stack -> {};
        this.predicate = stack -> true;
        this.isActive = () -> true;
        this.count = 64;
        this.showCountPredicate = () -> this.showCount;
        this.recipeFilter = false;
        this.fluidFilter = false;
        this.upTo = true;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128365_("Filter", (Tag)this.getFilter().serializeNBT());
        nbt.m_128405_("FilterAmount", this.count);
        nbt.m_128379_("UpTo", this.upTo);
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        this.filter = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Filter"));
        this.count = nbt.m_128451_("FilterAmount");
        this.upTo = nbt.m_128471_("UpTo");
        if (this.count == 0) {
            this.upTo = true;
            this.count = this.filter.m_41741_();
        }
        super.read(nbt, clientPacket);
    }

    public FilteringBehaviour withCallback(Consumer<ItemStack> filterCallback) {
        this.callback = filterCallback;
        return this;
    }

    public FilteringBehaviour withPredicate(Predicate<ItemStack> filterPredicate) {
        this.predicate = filterPredicate;
        return this;
    }

    public FilteringBehaviour forRecipes() {
        this.recipeFilter = true;
        return this;
    }

    public FilteringBehaviour forFluids() {
        this.fluidFilter = true;
        return this;
    }

    public FilteringBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    public FilteringBehaviour showCountWhen(Supplier<Boolean> condition) {
        this.showCountPredicate = condition;
        return this;
    }

    public FilteringBehaviour showCount() {
        this.showCount = true;
        return this;
    }

    public boolean setFilter(Direction face, ItemStack stack) {
        return this.setFilter(stack);
    }

    public void setLabel(MutableComponent label) {
        this.customLabel = label;
    }

    public boolean setFilter(ItemStack stack) {
        ItemStack filter = stack.m_41777_();
        if (!filter.m_41619_() && !this.predicate.test(filter)) {
            return false;
        }
        this.filter = filter;
        if (!this.upTo) {
            this.count = Math.min(this.count, stack.m_41741_());
        }
        this.callback.accept(filter);
        this.blockEntity.m_6596_();
        this.blockEntity.sendData();
        return true;
    }

    @Override
    public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings settings, boolean ctrlDown) {
        if (this.getValueSettings().equals(settings)) {
            return;
        }
        this.count = Mth.m_14045_((int)settings.value(), (int)1, (int)this.filter.m_41741_());
        this.upTo = settings.row() == 0;
        this.blockEntity.m_6596_();
        this.blockEntity.sendData();
        this.playFeedbackSound(this);
    }

    @Override
    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return new ValueSettingsBehaviour.ValueSettings(this.upTo ? 0 : 1, this.count == 0 ? this.filter.m_41741_() : this.count);
    }

    @Override
    public void destroy() {
        if (this.filter.m_41720_() instanceof FilterItem) {
            Vec3 pos = VecHelper.getCenterOf((Vec3i)this.getPos());
            Level world = this.getWorld();
            world.m_7967_((Entity)new ItemEntity(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.filter.m_41777_()));
        }
        super.destroy();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        Item filterItem = this.filter.m_41720_();
        if (filterItem instanceof FilterItem) {
            return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, filterItem);
        }
        return ItemRequirement.NONE;
    }

    public ItemStack getFilter(Direction side) {
        return this.getFilter();
    }

    public ItemStack getFilter() {
        return this.filter.m_41777_();
    }

    public boolean isCountVisible() {
        return this.showCountPredicate.get() != false && this.filter.m_41741_() > 1;
    }

    public boolean test(ItemStack stack) {
        return !this.isActive() || this.filter.m_41619_() || FilterItem.test(this.blockEntity.m_58904_(), stack, this.filter);
    }

    public boolean test(FluidStack stack) {
        return !this.isActive() || this.filter.m_41619_() || FilterItem.test(this.blockEntity.m_58904_(), stack, this.filter);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @Override
    public boolean testHit(Vec3 hit) {
        BlockState state = this.blockEntity.m_58900_();
        Vec3 localHit = hit.m_82546_(Vec3.m_82528_((Vec3i)this.blockEntity.m_58899_()));
        return this.slotPositioning.testHit(state, localHit);
    }

    public int getAmount() {
        return this.count;
    }

    public boolean anyAmount() {
        return this.count == 0;
    }

    @Override
    public boolean acceptsValueSettings() {
        return this.isCountVisible();
    }

    @Override
    public boolean isActive() {
        return this.isActive.get();
    }

    @Override
    public ValueBoxTransform getSlotPositioning() {
        return this.slotPositioning;
    }

    @Override
    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        ItemStack filter = this.getFilter(hitResult.m_82434_());
        int maxAmount = filter.m_41720_() instanceof FilterItem ? 64 : filter.m_41741_();
        return new ValueSettingsBoard((Component)Lang.translateDirect("logistics.filter.extracted_amount", new Object[0]), maxAmount, 16, Lang.translatedOptions("logistics.filter", "up_to", "exactly"), new ValueSettingsFormatter(this::formatValue));
    }

    public MutableComponent formatValue(ValueSettingsBehaviour.ValueSettings value) {
        if (value.row() == 0 && value.value() == this.filter.m_41741_()) {
            return Lang.translateDirect("logistics.filter.any_amount_short", new Object[0]);
        }
        return Components.literal((value.row() == 0 ? "\u2264" : "=") + Math.max(1, value.value()));
    }

    @Override
    public void onShortInteract(Player player, InteractionHand hand, Direction side) {
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        ItemStack itemInHand = player.m_21120_(hand);
        ItemStack toApply = itemInHand.m_41777_();
        if (AllItems.WRENCH.isIn(toApply)) {
            return;
        }
        if (AllBlocks.MECHANICAL_ARM.isIn(toApply)) {
            return;
        }
        if (level.m_5776_()) {
            return;
        }
        if (this.getFilter(side).m_41720_() instanceof FilterItem && (!player.m_7500_() || ItemHelper.extract((IItemHandler)new InvWrapper((Container)player.m_150109_()), stack -> ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.getFilter(side)), true).m_41619_())) {
            player.m_150109_().m_150079_(this.getFilter(side));
        }
        if (toApply.m_41720_() instanceof FilterItem) {
            toApply.m_41764_(1);
        }
        if (!this.setFilter(side, toApply)) {
            player.m_5661_((Component)Lang.translateDirect("logistics.filter.invalid_item", new Object[0]), true);
            AllSoundEvents.DENY.playOnServer(player.f_19853_, (Vec3i)player.m_20183_(), 1.0f, 1.0f);
            return;
        }
        if (!player.m_7500_() && toApply.m_41720_() instanceof FilterItem) {
            if (itemInHand.m_41613_() == 1) {
                player.m_21008_(hand, ItemStack.f_41583_);
            } else {
                itemInHand.m_41774_(1);
            }
        }
        level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.25f, 0.1f);
    }

    public MutableComponent getLabel() {
        if (this.customLabel != null) {
            return this.customLabel;
        }
        return Lang.translateDirect(this.recipeFilter ? "logistics.recipe_filter" : (this.fluidFilter ? "logistics.fluid_filter" : "logistics.filter"), new Object[0]);
    }

    @Override
    public String getClipboardKey() {
        return "Filtering";
    }

    @Override
    public boolean writeToClipboard(CompoundTag tag, Direction side) {
        ValueSettingsBehaviour.super.writeToClipboard(tag, side);
        ItemStack filter = this.getFilter(side);
        tag.m_128365_("Filter", (Tag)filter.serializeNBT());
        return true;
    }

    @Override
    public boolean readFromClipboard(CompoundTag tag, Player player, Direction side, boolean simulate) {
        ItemStack copied;
        Item item;
        boolean upstreamResult = ValueSettingsBehaviour.super.readFromClipboard(tag, player, side, simulate);
        if (!tag.m_128441_("Filter")) {
            return upstreamResult;
        }
        if (simulate) {
            return true;
        }
        if (this.getWorld().f_46443_) {
            return true;
        }
        ItemStack refund = ItemStack.f_41583_;
        if (this.getFilter(side).m_41720_() instanceof FilterItem && !player.m_7500_()) {
            refund = this.getFilter(side).m_41777_();
        }
        if ((item = (copied = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Filter"))).m_41720_()) instanceof FilterItem) {
            FilterItem filterType = (FilterItem)item;
            if (!player.m_7500_()) {
                InvWrapper inv = new InvWrapper((Container)player.m_150109_());
                for (boolean preferStacksWithoutData : Iterate.trueAndFalse) {
                    if (refund.m_41720_() != filterType && ItemHelper.extract((IItemHandler)inv, stack -> stack.m_41720_() == filterType && preferStacksWithoutData != stack.m_41782_(), 1, false).m_41619_()) continue;
                    if (!refund.m_41619_() && refund.m_41720_() != filterType) {
                        player.m_150109_().m_150079_(refund);
                    }
                    this.setFilter(side, copied);
                    return true;
                }
                player.m_5661_((Component)Lang.translate("logistics.filter.requires_item_in_inventory", copied.m_41786_().m_6881_().m_130940_(ChatFormatting.WHITE)).style(ChatFormatting.RED).component(), true);
                AllSoundEvents.DENY.playOnServer(player.f_19853_, (Vec3i)player.m_20183_(), 1.0f, 1.0f);
                return false;
            }
        }
        if (!refund.m_41619_()) {
            player.m_150109_().m_150079_(refund);
        }
        return this.setFilter(side, copied);
    }
}

