/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.client.model;

import blusunrize.immersiveengineering.client.utils.ModelUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import twistedgate.immersiveposts.client.model.IPOBakedModel;
import twistedgate.immersiveposts.client.model.IPOModelData;
import twistedgate.immersiveposts.common.tileentity.PostBaseTileEntity;

public class PostBaseModel
extends IPOBakedModel {
    public static final Cache<Key, SpecialPostBaseModel> CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).build();
    private static final ChunkRenderTypeSet RENDER_TYPE = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
    static TextureAtlasSprite postbaseSprite;

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        Key key;
        SpecialPostBaseModel special;
        BlockState hState = Blocks.f_50493_.m_49966_();
        Direction facing = Direction.NORTH;
        if (extraData.has(IPOModelData.POSTBASE)) {
            IPOModelData.PostBaseModelData data = (IPOModelData.PostBaseModelData)extraData.get(IPOModelData.POSTBASE);
            hState = data.state;
            facing = data.facing;
        }
        if ((special = (SpecialPostBaseModel)CACHE.getIfPresent((Object)(key = new Key(hState, facing)))) == null) {
            special = new SpecialPostBaseModel(key);
            CACHE.put((Object)key, (Object)special);
        }
        return special.m_213637_(state, side, rand);
    }

    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        ModelData.Builder mData = super.getModelData(world, pos, state, tileData).derive();
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PostBaseTileEntity) {
            PostBaseTileEntity base = (PostBaseTileEntity)blockEntity;
            IPOModelData.PostBaseModelData data = new IPOModelData.PostBaseModelData(base);
            mData.with(IPOModelData.POSTBASE, (Object)data);
        }
        return mData.build();
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return RENDER_TYPE;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    static TextureAtlasSprite getPostbaseSprite() {
        if (postbaseSprite == null) {
            postbaseSprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(new ResourceLocation("immersiveposts", "block/postbase"));
        }
        return postbaseSprite;
    }

    public TextureAtlasSprite m_6160_() {
        return PostBaseModel.getPostbaseSprite();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    private static class Key {
        final BlockState state;
        final Direction facing;

        public Key(BlockState state, Direction facing) {
            this.state = state;
            this.facing = facing;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof Key) {
                Key other = (Key)obj;
                return this.state.equals(other.state) && this.facing == other.facing;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.state.hashCode() + Objects.hash(this.facing);
        }
    }

    private static class SpecialPostBaseModel
    extends PostBaseModel {
        private static final RandomSource RANDOM = RandomSource.m_216327_();
        private static final Vec3[] verts = new Vec3[]{new Vec3(0.25, (double)1.001f, 0.25), new Vec3(0.25, (double)1.001f, 0.75), new Vec3(0.75, (double)1.001f, 0.75), new Vec3(0.75, (double)1.001f, 0.25)};
        private static final double[] uvs = new double[]{8.0, 0.0, 16.0, 8.0};
        private static final float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        List<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(6);

        public SpecialPostBaseModel(Key key) {
            this.build(key);
        }

        private void build(Key key) {
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(key.state);
            for (Direction side : Direction.values()) {
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                quads.addAll(model.getQuads(key.state, side, RANDOM, ModelData.EMPTY, (RenderType)null));
                if (side == Direction.UP) {
                    TextureAtlasSprite sprite = SpecialPostBaseModel.getPostbaseSprite();
                    quads.add(ModelUtils.createBakedQuad((Vec3[])verts, (Direction)side, (TextureAtlasSprite)sprite, (double[])uvs, (float[])color, (boolean)false));
                }
                this.quads.add(quads);
            }
            this.quads.add((List<BakedQuad>)ImmutableList.of());
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nullable RandomSource rand, @Nullable ModelData extraData, RenderType layer) {
            return this.quads.get(side == null ? this.quads.size() - 1 : side.m_122411_());
        }
    }

    public static class Loader
    implements IGeometryLoader<PostBaseModelRaw> {
        public static final ResourceLocation LOCATION = new ResourceLocation("immersiveposts", "postbase");

        public PostBaseModelRaw read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new PostBaseModelRaw();
        }

        public static class PostBaseModelRaw
        implements IUnbakedGeometry<PostBaseModelRaw> {
            public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
                return new PostBaseModel();
            }

            public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
                return ImmutableList.of();
            }
        }
    }
}

