/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common;

import com.electronwill.nightconfig.core.Config;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import twistedgate.immersiveposts.common.IPOContent;
import twistedgate.immersiveposts.enums.EnumPostMaterial;

@Mod.EventBusSubscriber(modid="immersiveposts", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IPOConfig {
    public static final Logger log = LogManager.getLogger((String)"immersiveposts/Config");
    public static final ForgeConfigSpec ALL;
    public static final Posts MAIN;
    private static Config rawConfig;

    public static Config getRawConfig() {
        if (rawConfig == null) {
            try {
                Field childConfig = ForgeConfigSpec.class.getDeclaredField("childConfig");
                childConfig.setAccessible(true);
                rawConfig = (Config)childConfig.get(ALL);
                Preconditions.checkNotNull((Object)rawConfig);
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        return rawConfig;
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent ev) {
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        MAIN = new Posts(builder);
        ALL = builder.build();
    }

    public static class Posts {
        public final ForgeConfigSpec.BooleanValue enableIron;
        public final ForgeConfigSpec.BooleanValue enableGold;
        public final ForgeConfigSpec.BooleanValue enableCopper;
        public final ForgeConfigSpec.BooleanValue enableLead;
        public final ForgeConfigSpec.BooleanValue enableSilver;
        public final ForgeConfigSpec.BooleanValue enableNickel;
        public final ForgeConfigSpec.BooleanValue enableConstantan;
        public final ForgeConfigSpec.BooleanValue enableElectrum;
        public final ForgeConfigSpec.BooleanValue enableUranium;
        public final ForgeConfigSpec.BooleanValue enableNether;
        public final ForgeConfigSpec.BooleanValue enableConcrete;
        public final ForgeConfigSpec.BooleanValue enableConcreteLeaded;
        public final ForgeConfigSpec.IntValue maxTrussLength;

        Posts(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"Maximum length of Horizontal Trusses", "Does not affect already existing Trusses when changed", "Default: 8"});
            this.maxTrussLength = builder.defineInRange("maxTrussLength", 8, 3, 128);
            builder.push("Post Types");
            builder.comment(new String[]{"For the removal of unwanted post variants.", "Simply set any of them to \"false\" to \"remove\", ez.."});
            this.enableIron = builder.define("iron", true);
            this.enableGold = builder.define("gold", true);
            this.enableCopper = builder.define("copper", true);
            this.enableLead = builder.define("lead", true);
            this.enableSilver = builder.define("silver", true);
            this.enableNickel = builder.define("nickel", true);
            this.enableConstantan = builder.define("constantan", true);
            this.enableElectrum = builder.define("electrum", true);
            this.enableUranium = builder.define("uranium", true);
            this.enableNether = builder.define("nether", true);
            this.enableConcrete = builder.define("concrete", true);
            this.enableConcreteLeaded = builder.define("concreteleaded", true);
            builder.pop();
        }

        public boolean isEnabled(Item item) {
            return IPOContent.containsBlockOrItem(null, item);
        }

        public boolean isEnabled(Block block) {
            return IPOContent.containsBlockOrItem(block, null);
        }

        public boolean isEnabled(ResourceLocation loc) {
            try {
                String name = loc.m_135815_().substring(loc.m_135815_().indexOf(95) + 1).toUpperCase();
                return this.isEnabled(EnumPostMaterial.valueOf(name));
            }
            catch (Exception e) {
                return true;
            }
        }

        public boolean isEnabled(EnumPostMaterial material) {
            if (material == null) {
                return true;
            }
            switch (material) {
                case CONCRETE: {
                    return (Boolean)this.enableConcrete.get();
                }
                case CONCRETE_LEADED: {
                    return (Boolean)this.enableConcreteLeaded.get();
                }
                case CONSTANTAN: {
                    return (Boolean)this.enableConstantan.get();
                }
                case COPPER: {
                    return (Boolean)this.enableCopper.get();
                }
                case ELECTRUM: {
                    return (Boolean)this.enableElectrum.get();
                }
                case GOLD: {
                    return (Boolean)this.enableGold.get();
                }
                case IRON: {
                    return (Boolean)this.enableIron.get();
                }
                case LEAD: {
                    return (Boolean)this.enableLead.get();
                }
                case NETHERBRICK: {
                    return (Boolean)this.enableNether.get();
                }
                case NICKEL: {
                    return (Boolean)this.enableNickel.get();
                }
                case SILVER: {
                    return (Boolean)this.enableSilver.get();
                }
                case URANIUM: {
                    return (Boolean)this.enableUranium.get();
                }
            }
            return true;
        }
    }
}

