/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.TooltipButton;
import xaero.map.settings.ModOptions;
import xaero.map.world.MapDimension;

public class GuiCaveModeOptions {
    private MapDimension dimension;
    private boolean enabled;
    private AbstractWidget caveModeStartSlider;
    private EditBox caveModeStartField;

    public void onInit(GuiMap screen) {
        this.caveModeStartSlider = null;
        this.caveModeStartField = null;
        this.dimension = screen.getDimension();
        if (this.enabled && this.dimension != null) {
            this.updateSlider(screen);
            this.updateField(screen);
            CursorBox caveModeTypeButtonTooltip = new CursorBox("gui.xaero_wm_box_cave_mode_type");
            screen.addButton(new TooltipButton(20, screen.f_96544_ - 62, 150, 20, this.getCaveModeTypeButtonMessage(), b -> this.onCaveModeTypeButton(b, screen), () -> caveModeTypeButtonTooltip));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCaveModeTypeButton(Button b, GuiMap screen) {
        this.dimension.toggleCaveModeType(true);
        Object object = screen.getMapProcessor().uiSync;
        synchronized (object) {
            this.dimension.saveConfigUnsynced();
        }
        b.m_93666_(this.getCaveModeTypeButtonMessage());
    }

    private EditBox createField(GuiMap screen) {
        EditBox field = new EditBox(Minecraft.m_91087_().f_91062_, 172, screen.f_96544_ - 40, 50, 20, (Component)Component.m_237115_((String)"gui.xaero_wm_cave_mode_start"));
        field.m_94199_(7);
        field.m_94144_((String)(WorldMap.settings.caveModeStart == Integer.MAX_VALUE ? "" : "" + WorldMap.settings.caveModeStart));
        field.m_94151_(text -> {
            try {
                WorldMap.settings.caveModeStart = text.isEmpty() || text.equalsIgnoreCase("auto") ? Integer.MAX_VALUE : Integer.parseInt(text);
                this.updateSlider(screen);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        return field;
    }

    private AbstractWidget createSlider(GuiMap screen) {
        return ModOptions.CAVE_MODE_START.getXOption().createButton(20, screen.f_96544_ - 40, 150);
    }

    private void updateField(GuiMap screen) {
        if (this.caveModeStartField == null) {
            this.caveModeStartField = this.createField(screen);
            screen.addButton(this.caveModeStartField);
        } else {
            this.caveModeStartField = this.createField(screen);
            screen.replaceRenderableWidget((AbstractWidget)this.caveModeStartField, (AbstractWidget)this.caveModeStartField);
        }
    }

    private void updateSlider(GuiMap screen) {
        if (this.caveModeStartSlider == null) {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.addButton(this.caveModeStartSlider);
        } else {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.replaceRenderableWidget(this.caveModeStartSlider, this.caveModeStartSlider);
        }
    }

    public void toggle(GuiMap screen) {
        this.enabled = WorldMap.settings.isCaveMapsAllowed() && !this.enabled;
        screen.m_6575_(Minecraft.m_91087_(), screen.f_96543_, screen.f_96544_);
    }

    public void onCaveModeStartSet(GuiMap screen) {
        if (this.enabled) {
            this.updateField(screen);
        }
    }

    public void tick(GuiMap screen) {
        if (this.enabled) {
            this.caveModeStartField.m_94167_(this.caveModeStartField.m_94155_().isEmpty() ? I18n.m_118938_((String)"gui.xaero_wm_cave_mode_start_auto", (Object[])new Object[0]) : "");
            this.caveModeStartField.m_94120_();
        }
    }

    public void unfocusAll() {
        if (this.caveModeStartField != null) {
            this.caveModeStartField.m_94178_(false);
        }
        if (this.caveModeStartSlider != null && this.caveModeStartSlider.m_93696_()) {
            this.caveModeStartSlider.m_5755_(true);
        }
    }

    private Component getCaveModeTypeButtonMessage() {
        return Component.m_237113_((String)(I18n.m_118938_((String)"gui.xaero_wm_cave_mode_type", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)(this.dimension == null ? "N/A" : (this.dimension.getCaveModeType() == 0 ? "gui.xaero_off" : (this.dimension.getCaveModeType() == 1 ? "gui.xaero_wm_cave_mode_type_layered" : "gui.xaero_wm_cave_mode_type_full"))), (Object[])new Object[0])));
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

