/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.events.SoftMenuReloadEvent;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerBase;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.MainMenuHandler;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraftforge.client.event.ScreenEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LoadingOverlay.class})
public abstract class MixinLoadingOverlay
extends GuiComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean animationsLoaded = false;
    private static boolean firstScreenInit = true;
    private MenuHandlerBase menuHandler = null;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructFancyMenu(Minecraft mc, ReloadInstance reloadInstance, Consumer consumer, boolean b, CallbackInfo info) {
        if (!animationsLoaded) {
            FancyMenu.initConfig();
            animationsLoaded = true;
            LOGGER.info("[FANCYMENU] Pre-loading animations if enabled in config..");
            AnimationHandler.preloadAnimations();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V")})
    private void beforeRenderScreenFancyMenu(PoseStack matrix, int mouseX, int mouseY, float partial, CallbackInfo info) {
        if (Minecraft.m_91087_().f_91080_ != null && this.menuHandler != null && MenuCustomization.isMenuCustomizable(Minecraft.m_91087_().f_91080_)) {
            this.menuHandler.onRenderPre(new ScreenEvent.Render.Pre(Minecraft.m_91087_().f_91080_, matrix, mouseX, mouseY, partial));
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V", shift=At.Shift.AFTER)})
    private void afterRenderScreenFancyMenu(PoseStack matrix, int mouseX, int mouseY, float partial, CallbackInfo info) {
        if (Minecraft.m_91087_().f_91080_ != null && this.menuHandler != null && MenuCustomization.isMenuCustomizable(Minecraft.m_91087_().f_91080_)) {
            if (this.menuHandler instanceof MainMenuHandler) {
                Minecraft.m_91087_().f_91080_.m_7333_(matrix);
            }
            this.menuHandler.onRenderPost(new ScreenEvent.Render.Post(Minecraft.m_91087_().f_91080_, matrix, mouseX, mouseY, partial));
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init(Lnet/minecraft/client/Minecraft;II)V", shift=At.Shift.AFTER)})
    private void afterInitScreenFancyMenu(PoseStack matrix, int mouseX, int mouseY, float partial, CallbackInfo info) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            AnimationHandler.setReady(true);
            MenuCustomization.allowScreenCustomization = true;
            this.menuHandler = MenuHandlerRegistry.getHandlerFor(Minecraft.m_91087_().f_91080_);
            if (this.menuHandler != null && firstScreenInit) {
                this.menuHandler.onSoftReload(new SoftMenuReloadEvent(Minecraft.m_91087_().f_91080_));
            }
            firstScreenInit = false;
            MenuCustomization.setIsNewMenu(true);
            Minecraft.m_91087_().m_91152_(Minecraft.m_91087_().f_91080_);
        }
    }
}

