/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.blocks;

import java.util.List;
import mod.casinocraft.CasinoCraft;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.tileentities.TileEntityArcade;
import mod.casinocraft.tileentities.TileEntityBoard;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockArcade
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool PRIMARY = PropertyBool.func_177716_a((String)"primary");
    public static final PropertyEnum<EnumModule> MODULE = PropertyEnum.func_177709_a((String)"module", EnumModule.class);
    final EnumDyeColor color;

    public BlockArcade(String name, EnumDyeColor colorIn) {
        super(Material.field_151574_g);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
        this.func_149672_a(SoundType.field_185858_k);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149675_a(false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(MODULE, (Comparable)((Object)EnumModule.OFF)).func_177226_a((IProperty)PRIMARY, (Comparable)Boolean.valueOf(true)));
        this.color = colorIn;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityBoard te = (TileEntityBoard)worldIn.func_175625_s(pos);
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)PRIMARY, (Comparable)Boolean.valueOf(true)).func_177226_a(MODULE, (Comparable)((Object)EnumModule.OFF)));
        if (worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)PRIMARY, (Comparable)Boolean.valueOf(false)).func_177226_a(MODULE, (Comparable)((Object)EnumModule.OFF)));
        } else {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        boolean isPrimary = (Boolean)state.func_177229_b((IProperty)PRIMARY);
        if (isPrimary && !worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            List drops = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockArcade.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        boolean isPrimary = (Boolean)state.func_177229_b((IProperty)PRIMARY);
        if (isPrimary) {
            worldIn.func_175655_b(pos.func_177984_a(), true);
        } else {
            worldIn.func_175655_b(pos.func_177977_b(), true);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        boolean isPrimary = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)PRIMARY);
        if (isPrimary) {
            world.func_175655_b(pos.func_177984_a(), true);
        } else {
            world.func_175655_b(pos.func_177977_b(), true);
        }
        world.func_175698_g(pos);
        this.func_180652_a(world, pos, explosion);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        BlockPos pos2 = pos;
        boolean isPrimary = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)PRIMARY);
        Item item = Items.field_151145_ak;
        if (!isPrimary) {
            pos2 = pos.func_177977_b();
        }
        if (world.func_175625_s(pos2) instanceof TileEntityBoard) {
            TileEntityBoard te = (TileEntityBoard)world.func_175625_s(pos2);
            if (te.func_70301_a(0).func_190926_b() || te.func_70301_a(0).func_77973_b() == player.func_184586_b(hand).func_77973_b()) {
                player.openGui((Object)CasinoCraft.instance, 48, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_WHITE) {
                player.openGui((Object)CasinoCraft.instance, 0, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_ORANGE) {
                player.openGui((Object)CasinoCraft.instance, 1, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_MAGENTA) {
                player.openGui((Object)CasinoCraft.instance, 2, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_LIGHTBLUE) {
                player.openGui((Object)CasinoCraft.instance, 3, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_YELLOW) {
                player.openGui((Object)CasinoCraft.instance, 4, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_LIME) {
                player.openGui((Object)CasinoCraft.instance, 5, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_PINK) {
                player.openGui((Object)CasinoCraft.instance, 6, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_GRAY) {
                player.openGui((Object)CasinoCraft.instance, 7, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_SILVER) {
                player.openGui((Object)CasinoCraft.instance, 8, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_CYAN) {
                player.openGui((Object)CasinoCraft.instance, 9, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_PURPLE) {
                player.openGui((Object)CasinoCraft.instance, 10, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_BLUE) {
                player.openGui((Object)CasinoCraft.instance, 11, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_BROWN) {
                player.openGui((Object)CasinoCraft.instance, 12, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_GREEN) {
                player.openGui((Object)CasinoCraft.instance, 13, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_RED) {
                player.openGui((Object)CasinoCraft.instance, 14, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else if (((ItemStack)te.inventory.get(1)).func_77973_b() == CasinoKeeper.MODULE_CHIP_BLACK) {
                player.openGui((Object)CasinoCraft.instance, 15, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            } else {
                player.openGui((Object)CasinoCraft.instance, 52, world, pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p());
            }
            te.func_70296_d();
        }
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return meta < 8 ? null : new TileEntityArcade(this.color, 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PRIMARY, MODULE});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(meta % 8));
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)PRIMARY, (Comparable)Boolean.valueOf(meta / 8 > 0)).func_177226_a(MODULE, (Comparable)((Object)EnumModule.OFF));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)PRIMARY)).booleanValue()) {
            i += 8;
        }
        return i;
    }

    public static void setModuleState(World world, BlockPos pos) {
        IBlockState iblockstate = world.func_180495_p(pos);
        TileEntityBoard tileentity = (TileEntityBoard)world.func_175625_s(pos);
        if (tileentity != null) {
            if (((ItemStack)tileentity.inventory.get(0)).func_190926_b()) {
                world.func_180501_a(pos, iblockstate.func_177226_a(MODULE, (Comparable)((Object)EnumModule.OFF)), 3);
                world.func_180501_a(pos.func_177984_a(), iblockstate.func_177226_a((IProperty)PRIMARY, (Comparable)Boolean.valueOf(false)).func_177226_a(MODULE, (Comparable)((Object)EnumModule.OFF)), 3);
                tileentity.func_145829_t();
                world.func_175690_a(pos, (TileEntity)tileentity);
            } else {
                world.func_180501_a(pos, iblockstate.func_177226_a(MODULE, (Comparable)((Object)EnumModule.byItem(((ItemStack)tileentity.inventory.get(1)).func_77973_b()))), 3);
                world.func_180501_a(pos.func_177984_a(), iblockstate.func_177226_a((IProperty)PRIMARY, (Comparable)Boolean.valueOf(false)).func_177226_a(MODULE, (Comparable)((Object)EnumModule.byItem(((ItemStack)tileentity.inventory.get(1)).func_77973_b()))), 3);
                tileentity.func_145829_t();
                world.func_175690_a(pos, (TileEntity)tileentity);
            }
        }
    }

    public static enum EnumModule implements IStringSerializable
    {
        BLACK(0, "black"),
        RED(1, "red"),
        GREEN(2, "green"),
        BROWN(3, "brown"),
        BLUE(4, "blue"),
        PURPLE(5, "purple"),
        CYAN(6, "cyan"),
        SILVER(7, "silver"),
        GRAY(8, "gray"),
        PINK(9, "pink"),
        LIME(10, "lime"),
        YELLOW(11, "yellow"),
        LIGHTBLUE(12, "lightblue"),
        MAGENTA(13, "magenta"),
        ORANGE(14, "orange"),
        WHITE(15, "white"),
        EMPTY(16, "empty"),
        OFF(17, "off");

        public final String name;
        public final int meta;

        private EnumModule(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumModule byMetadata(int meta) {
            return EMPTY;
        }

        public static EnumModule byItem(Item item) {
            if (item == CasinoKeeper.MODULE_CHIP_BLACK) {
                return BLACK;
            }
            if (item == CasinoKeeper.MODULE_CHIP_RED) {
                return RED;
            }
            if (item == CasinoKeeper.MODULE_CHIP_GREEN) {
                return GREEN;
            }
            if (item == CasinoKeeper.MODULE_CHIP_BROWN) {
                return BROWN;
            }
            if (item == CasinoKeeper.MODULE_CHIP_BLUE) {
                return BLUE;
            }
            if (item == CasinoKeeper.MODULE_CHIP_PURPLE) {
                return PURPLE;
            }
            if (item == CasinoKeeper.MODULE_CHIP_CYAN) {
                return CYAN;
            }
            if (item == CasinoKeeper.MODULE_CHIP_SILVER) {
                return SILVER;
            }
            if (item == CasinoKeeper.MODULE_CHIP_GRAY) {
                return GRAY;
            }
            if (item == CasinoKeeper.MODULE_CHIP_PINK) {
                return PINK;
            }
            if (item == CasinoKeeper.MODULE_CHIP_LIME) {
                return LIME;
            }
            if (item == CasinoKeeper.MODULE_CHIP_YELLOW) {
                return YELLOW;
            }
            if (item == CasinoKeeper.MODULE_CHIP_LIGHTBLUE) {
                return LIGHTBLUE;
            }
            if (item == CasinoKeeper.MODULE_CHIP_MAGENTA) {
                return MAGENTA;
            }
            if (item == CasinoKeeper.MODULE_CHIP_ORANGE) {
                return ORANGE;
            }
            if (item == CasinoKeeper.MODULE_CHIP_WHITE) {
                return WHITE;
            }
            return EMPTY;
        }
    }
}

