/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.mino;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicBase;
import net.minecraft.nbt.NBTTagCompound;

public class LogicMinoLime
extends LogicBase {
    public int[] alpha = new int[4];
    public List<Integer> color_simon = new ArrayList<Integer>();
    public List<Integer> color_player = new ArrayList<Integer>();
    public int alpha_pos = 0;
    public boolean[] alpha_player = new boolean[4];
    public boolean result;

    public LogicMinoLime(int tableID) {
        super(tableID);
    }

    @Override
    public void start2() {
        this.color_simon.clear();
        this.color_simon.add(this.RANDOM.nextInt(4));
        this.color_simon.add(this.RANDOM.nextInt(4));
        this.color_simon.add(this.RANDOM.nextInt(4));
        this.color_player.clear();
        this.alpha[0] = 0;
        this.alpha[1] = 0;
        this.alpha[2] = 0;
        this.alpha[3] = 0;
        this.alpha_pos = 0;
        this.result = false;
        this.scoreLevel = 1;
        this.alpha_player[0] = false;
        this.alpha_player[1] = false;
        this.alpha_player[2] = false;
        this.alpha_player[3] = false;
        this.turnstate = 3;
        this.alpha[this.color_simon.get((int)0).intValue()] = this.getAlpha();
    }

    public void restart() {
        ++this.scoreLevel;
        this.scorePoint += this.color_simon.size();
        this.color_simon.add(this.RANDOM.nextInt(4));
        this.color_simon.add(this.RANDOM.nextInt(4));
        this.color_player.clear();
        this.alpha[0] = 0;
        this.alpha[1] = 0;
        this.alpha[2] = 0;
        this.alpha[3] = 0;
        this.alpha_pos = 0;
        this.alpha_player[0] = false;
        this.alpha_player[1] = false;
        this.alpha_player[2] = false;
        this.alpha_player[3] = false;
        this.turnstate = 3;
        this.result = false;
        this.alpha[this.color_simon.get((int)0).intValue()] = this.getAlpha();
    }

    @Override
    public void command(int action) {
        this.color_player.add(action);
        this.alpha[action] = this.getAlpha();
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void updateLogic() {
        for (int i = 0; i < 4; ++i) {
            if (this.alpha[i] <= 0) continue;
            int n = i;
            this.alpha[n] = this.alpha[n] - 1;
            if (this.alpha[i] > 0) continue;
            this.alpha[i] = 0;
        }
        if (this.turnstate == 2) {
            if (this.color_simon.size() == this.color_player.size() && this.alpha[0] == 0 && this.alpha[1] == 0 && this.alpha[2] == 0 && this.alpha[3] == 0) {
                boolean match = true;
                for (int i = 0; i < this.color_player.size(); ++i) {
                    if (this.color_player.get(i) == this.color_simon.get(i)) continue;
                    match = false;
                }
                if (!match) {
                    this.turnstate = 4;
                } else {
                    this.restart();
                }
            }
        } else if (this.turnstate == 3 && this.alpha[0] == 0 && this.alpha[1] == 0 && this.alpha[2] == 0 && this.alpha[3] == 0) {
            ++this.alpha_pos;
            if (this.alpha_pos == this.color_simon.size()) {
                this.turnstate = 2;
            } else {
                this.alpha[this.color_simon.get((int)this.alpha_pos).intValue()] = this.getAlpha();
            }
        }
    }

    @Override
    public void load2(NBTTagCompound compound) {
        this.alpha[0] = compound.func_74762_e("alpha0");
        this.alpha[1] = compound.func_74762_e("alpha1");
        this.alpha[2] = compound.func_74762_e("alpha2");
        this.alpha[3] = compound.func_74762_e("alpha3");
        int[] i = compound.func_74759_k("colorsimon");
        this.color_simon.clear();
        for (int x : i) {
            this.color_simon.add(x);
        }
        i = compound.func_74759_k("colorplayer");
        this.color_player.clear();
        for (int x : i) {
            this.color_player.add(x);
        }
        this.alpha_pos = compound.func_74762_e("alphapos");
        this.alpha_player[0] = compound.func_74767_n("alphaplayer0");
        this.alpha_player[1] = compound.func_74767_n("alphaplayer1");
        this.alpha_player[2] = compound.func_74767_n("alphaplayer2");
        this.alpha_player[3] = compound.func_74767_n("alphaplayer3");
        this.result = compound.func_74767_n("result");
    }

    @Override
    public NBTTagCompound save2(NBTTagCompound compound) {
        int[] array1 = new int[this.color_player.size()];
        for (int i = 0; i < array1.length; ++i) {
            array1[i] = this.color_player.get(i);
        }
        int[] array2 = new int[this.color_simon.size()];
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = this.color_simon.get(i);
        }
        compound.func_74768_a("alpha0", this.alpha[0]);
        compound.func_74768_a("alpha1", this.alpha[1]);
        compound.func_74768_a("alpha2", this.alpha[2]);
        compound.func_74768_a("alpha3", this.alpha[3]);
        compound.func_74783_a("colorsimon", array2);
        compound.func_74783_a("colorplayer", array1);
        compound.func_74768_a("alphapos", this.alpha_pos);
        compound.func_74757_a("alphaplayer0", this.alpha_player[0]);
        compound.func_74757_a("alphaplayer1", this.alpha_player[1]);
        compound.func_74757_a("alphaplayer2", this.alpha_player[2]);
        compound.func_74757_a("alphaplayer3", this.alpha_player[3]);
        compound.func_74757_a("result", this.result);
        return compound;
    }

    public int getAlpha() {
        return Math.max(10 - this.scoreLevel, 2);
    }

    @Override
    public boolean hasHighscore() {
        return true;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 40;
    }
}

