/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.network;

import io.netty.buffer.ByteBuf;
import mod.casinocraft.network.MessageBoardClient;
import mod.casinocraft.system.CasinoPacketHandler;
import mod.casinocraft.tileentities.TileEntityBoard;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageBoardServer
implements IMessage {
    int betLow;
    int betHigh;
    boolean transferIn;
    boolean transferOut;
    boolean isCreative;
    int x;
    int y;
    int z;

    public MessageBoardServer() {
    }

    public MessageBoardServer(int bet_low, int bet_high, boolean transfer_in, boolean transfer_out, boolean is_creative, BlockPos pos) {
        this.betLow = bet_low;
        this.betHigh = bet_high;
        this.transferIn = transfer_in;
        this.transferOut = transfer_out;
        this.isCreative = is_creative;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.betLow);
        buf.writeInt(this.betHigh);
        buf.writeBoolean(this.transferIn);
        buf.writeBoolean(this.transferOut);
        buf.writeBoolean(this.isCreative);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.betLow = buf.readInt();
            this.betHigh = buf.readInt();
            this.transferIn = buf.readBoolean();
            this.transferOut = buf.readBoolean();
            this.isCreative = buf.readBoolean();
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Handler
    implements IMessageHandler<MessageBoardServer, IMessage> {
        public IMessage onMessage(MessageBoardServer message, MessageContext context) {
            EntityPlayerMP serverPlayer = context.getServerHandler().field_147369_b;
            BlockPos pos = new BlockPos(message.x, message.y, message.z);
            TileEntityBoard te = (TileEntityBoard)context.getServerHandler().field_147369_b.field_70170_p.func_175625_s(pos);
            serverPlayer.func_71121_q().func_152344_a(() -> {
                te.bet_low = message.betLow;
                te.bet_high = message.betHigh;
                te.transfer_in = message.transferIn;
                te.transfer_out = message.transferOut;
                te.isCreative = message.isCreative;
            });
            CasinoPacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageBoardClient(message.betLow, message.betHigh, message.transferIn, message.transferOut, message.isCreative, pos), new NetworkRegistry.TargetPoint(context.getServerHandler().field_147369_b.field_71093_bK, (double)message.x, (double)message.y, (double)message.z, 64.0));
            return null;
        }
    }
}

