/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.network;

import io.netty.buffer.ByteBuf;
import mod.casinocraft.network.MessageStateClient;
import mod.casinocraft.system.CasinoPacketHandler;
import mod.casinocraft.tileentities.TileEntityBoard;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageStateServer
implements IMessage {
    boolean system;
    int state;
    int x;
    int y;
    int z;

    public MessageStateServer() {
    }

    public MessageStateServer(boolean system, int state, BlockPos pos) {
        this.system = system;
        this.state = state;
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.system);
        buf.writeInt(this.state);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.system = buf.readBoolean();
            this.state = buf.readInt();
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Handler
    implements IMessageHandler<MessageStateServer, IMessage> {
        private boolean isEmpty(ItemStack stack) {
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150350_a)) {
                return true;
            }
            return stack.func_77973_b() == null;
        }

        public IMessage onMessage(MessageStateServer message, MessageContext context) {
            EntityPlayerMP serverPlayer = context.getServerHandler().field_147369_b;
            BlockPos pos = new BlockPos(message.x, message.y, message.z);
            TileEntityBoard te = (TileEntityBoard)context.getServerHandler().field_147369_b.field_70170_p.func_175625_s(pos);
            serverPlayer.func_71121_q().func_152344_a(() -> {
                if (message.system) {
                    if (message.state == -1) {
                        te.LOGIC.pause = !te.LOGIC.pause;
                    } else if (message.state == -2) {
                        te.LOGIC.resetPlayers();
                        te.LOGIC.turnstate = 0;
                    } else if (message.state == -3) {
                        te.LOGIC.resetPlayers();
                    } else if (message.state >= 10) {
                        te.LOGIC.reward[message.state - 10] = 0;
                    } else {
                        te.LOGIC.turnstate = message.state;
                    }
                } else {
                    te.LOGIC.command(message.state);
                }
            });
            CasinoPacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageStateClient(message.system, message.state, pos), new NetworkRegistry.TargetPoint(context.getServerHandler().field_147369_b.field_71093_bK, (double)message.x, (double)message.y, (double)message.z, 64.0));
            return null;
        }
    }
}

